#include <windows.h>
#include <tlhelp32.h>
#include <cstdio>
#include <string>
#include <vector>

#define PROCESSNAME (L"age3y.exe")
#define POP_MIN 200
#define POP_MAX 4000

std::vector<DWORD> processed;

int PopUnlock(DWORD pid, unsigned int population);

int main(int argc, char *argv[])
{
    unsigned int population = 400;
    if(argc==2)population=(unsigned int)atoi(argv[1]);
    if(population<POP_MIN)population=POP_MIN;
    if(population>POP_MAX)population=POP_MAX;

    printf("TAD v1.03 ONLY\n");
    printf("The hardcoded 250pop limit will be extended to %u\n",population);
    printf("Waiting for age3y.exe to run...\n\n");


    for(;;) //find age3y.exe and patch it
    {
        Sleep(5000);
        PROCESSENTRY32W proc;
        proc.dwSize=sizeof(PROCESSENTRY32W);
        HANDLE snap = CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS , 0);
        if(!Process32FirstW(snap,&proc))
        {
            CloseHandle(snap);
        }
        else
        {
            do{
                size_t v;
                for(v=0; v<processed.size(); v++)
                    if(processed[v]==proc.th32ProcessID)break;
                if(v==processed.size()) //if not yet processed
                {
                    if(!_wcsicmp(proc.szExeFile, PROCESSNAME)) //if age3y executable
                    {
                        if(PopUnlock(proc.th32ProcessID, population))
                        {
                            printf("PID:%u unlocked\n",(unsigned int)proc.th32ProcessID);
                            processed.push_back(proc.th32ProcessID);
                        }
                        else
                            printf("PID:%u !! failed\n",(unsigned int)proc.th32ProcessID);
                    }
                }
            }
            while(Process32NextW(snap,&proc));
        }
    }
    return 0;
}

int PopUnlock(DWORD pid, unsigned int population)
{
    bool stop=false;



    DWORD address1 = 0x4581F6;
    unsigned int asm1_size=6;
    BYTE asm1_mod[]={0x90,0x90,0x90,0x90,0x90,0x90}; //NOPs

    DWORD address2 = 0x00458234;
    unsigned int asm2_size=5;
    BYTE asm2_mod[] = {0x3D,0x90,0x01,0x00,0x00 };

    DWORD address3= 0x00679637;
    unsigned int asm3_size=5;
    BYTE asm3_mod[]={0xB8, 0xFA, 0x00, 0x00, 0x00};

    //prepare the edited assembly bits - copy the new population limit
    memcpy(&asm2_mod[1],&population,4);
	memcpy(&asm3_mod[1],&population,4);

    //Open the game process
    HANDLE pHandle= OpenProcess( PROCESS_VM_WRITE | PROCESS_VM_READ | PROCESS_VM_OPERATION, FALSE, pid);
    if(!pHandle)return 0;

    SIZE_T nb=0;
    DWORD oldProtect;
    DWORD newProtect;

    // ADDRESS 1
    //Unprotect memory
    oldProtect=0; newProtect=PAGE_EXECUTE_READWRITE;
    VirtualProtectEx(pHandle, (void*)address1, asm1_size, newProtect, &oldProtect);
    //Write new memory
    WriteProcessMemory(pHandle, (void*)address1,asm1_mod,asm1_size,&nb);
    if(nb!=asm1_size)
        stop=true;
    //Protect memory again
    VirtualProtectEx(pHandle, (void*)address1,asm1_size, oldProtect, &newProtect);
    if(stop){CloseHandle(pHandle); return 0;}

    // ADDRESS 2
    oldProtect=0; newProtect=PAGE_EXECUTE_READWRITE;
    VirtualProtectEx(pHandle, (void*)address2, asm2_size, newProtect, &oldProtect);
    WriteProcessMemory(pHandle, (void*)address2,asm2_mod,asm2_size,&nb);
    if(nb!=asm2_size)
        stop=true;
    VirtualProtectEx(pHandle, (void*)address2,asm2_size, oldProtect, &newProtect);
    if(stop){CloseHandle(pHandle); return 0;}

    // ADDRESS 3
    oldProtect=0; newProtect=PAGE_EXECUTE_READWRITE;
    VirtualProtectEx(pHandle, (void*)address3, asm3_size, newProtect, &oldProtect);
    WriteProcessMemory(pHandle, (void*)address3,asm3_mod,asm3_size,&nb);
    if(nb!=asm3_size)
        stop=true;
    VirtualProtectEx(pHandle, (void*)address3,asm3_size, oldProtect, &newProtect);
    if(stop){CloseHandle(pHandle); return 0;}

    return 1;
}
