//Map made by Furby_killer
// see http://home.student.utwente.nl/e.olieman/
// Mail me if you want to release a modified version of this map: erik.olieman@gmail.com

//Special thanks to M0nTy_PyTh0n for his tutorial and ES for making this great game



//first NR map - started with a modified version of rockies ;)
// ROCKIES - started with a modified version of Great Plains.
// July 2004
//
include "mercenaries.xs";

// Main entry point for random map script
void main(void)
{
   // Text
   // These status text lines are used to manually animate the map generation progress bar
   rmSetStatusText("",0.01);

   //Chooses which natives appear on the map
   int subCiv0=-1;
   int subCiv1=-1;

   /*
   int subCiv2=-1;
   int subCiv3=-1;
   int subCiv4=-1;
   int subCiv5=-1;
   */

	int whichNative=rmRandInt(1,2);
	if ( whichNative == 1)
	{
		subCiv0=rmGetCivID("Lakota");
		rmEchoInfo("subCiv0 is Lakota "+subCiv0);
		if (subCiv0 >= 0)
			rmSetSubCiv(0, "Lakota");

		subCiv1=rmGetCivID("Lakota");
		rmEchoInfo("subCiv1 is Lakota "+subCiv1);
		if (subCiv1 >= 0)
			rmSetSubCiv(1, "Lakota");
	}
	else
	{
		subCiv0=rmGetCivID("Comanche");
		rmEchoInfo("subCiv0 is Comanche "+subCiv0);
		if (subCiv0 >= 0)
			rmSetSubCiv(0, "Comanche");

		subCiv1=rmGetCivID("Comanche");
		rmEchoInfo("subCiv1 is Comanche "+subCiv1);
		if (subCiv1 >= 0)
			rmSetSubCiv(1, "Comanche");
	}

	// Choose which variation to use.  1=southeast trade route, 2=northwest trade route
	int whichMap=rmRandInt(1,2);
	// int whichMap=2;

	// Are there extra meeting poles?
	int extraPoles=rmRandInt(1,2);

	/*
	if (rmAllocateSubCivs(6) == true)
   {
      subCiv0=rmGetCivID("Cherokee");
      rmEchoInfo("subCiv0 is Cherokee "+subCiv0);
      if (subCiv0 >= 0)
         rmSetSubCiv(0, "Cherokee");
	
      subCiv1=rmGetCivID("Iroquois");
		rmEchoInfo("subCiv1 is Iroquois "+subCiv1);
		if (subCiv1 >= 0)
			rmSetSubCiv(1, "Iroquois");

		subCiv2=rmGetCivID("Cree");
      rmEchoInfo("subCiv2 is Cree"+subCiv2);
		  if (subCiv2 >= 0)
			 rmSetSubCiv(2, "Cree");
	 
		subCiv3=rmGetCivID("Seminoles");
      rmEchoInfo("subCiv3 is Seminoles"+subCiv3);
      if (subCiv3 >= 0)
         rmSetSubCiv(3, "Seminoles");
	  
		subCiv4=rmGetCivID("Comanche");
      rmEchoInfo("subCiv4 is Comanche"+subCiv4);
      if (subCiv4 >= 0)
         rmSetSubCiv(4, "Comanche");
     
		subCiv5=rmGetCivID("Lakota");
      rmEchoInfo("subCiv5 is Lakota "+subCiv5);
		if (subCiv5 >= 0)
			rmSetSubCiv(5, "Lakota");
   }
   */

   // Picks the map size
   int playerTiles=11500;
   int size=2.0*sqrt(cNumberNonGaiaPlayers*playerTiles);
   rmEchoInfo("Map size="+size+"m x "+size+"m");
   rmSetMapSize(size, size);

   // Picks a default water height
   rmSetSeaLevel(0.0);

   // Picks default terrain and water
	// DAL rmSetAreaMix(westDesertID, "texas_dirt");
	rmSetMapElevationParameters(cElevTurbulence, 0.02, 3, 0.5, 8.0);
	rmSetBaseTerrainMix("rockies_snow");
	rmTerrainInitialize("rockies\groundsnow1_roc", 12);	
	rmSetLightingSet("rockies");
	rmSetMapType("rockies");
	rmSetMapType("land");
	rmSetWorldCircleConstraint(true);
	// rmSetMapType("grass");

	chooseMercs();

    // Define some classes. These are used later for constraints.
   int classPlayer=rmDefineClass("player");
   rmDefineClass("classPatch");
   rmDefineClass("starting settlement");
   rmDefineClass("startingUnit");
   rmDefineClass("classForest");
   rmDefineClass("classCotton");
   rmDefineClass("importantItem");
	rmDefineClass("secrets");
	rmDefineClass("nuggets");
	rmDefineClass("classHillArea");
	rmDefineClass("classSmallHillArea");
	rmDefineClass("socketClass");
	rmDefineClass("classCliff");
	int middenrij=rmDefineClass("middenrijclass");
	int middenclass=rmDefineClass("middenclass");
   // -------------Define constraints
   // These are used to have objects and areas avoid each other
   
   // Map edge constraints
	int playerEdgeConstraint=rmCreateBoxConstraint("player edge of map", rmXTilesToFraction(6), rmZTilesToFraction(6), 1.0-rmXTilesToFraction(6), 1.0-rmZTilesToFraction(6), 0.01);
	int silverEdgeConstraint=rmCreateBoxConstraint("silver edge of map", rmXTilesToFraction(20), rmZTilesToFraction(20), 1.0-rmXTilesToFraction(20), 1.0-rmZTilesToFraction(20), 0.01);
	// int forestEdgeConstraint=rmCreateBoxConstraint("forest edge of map", rmXTilesToFraction(30), rmZTilesToFraction(30), 1.0-rmXTilesToFraction(30), 1.0-rmZTilesToFraction(30), 0.01);
	// int forestEdgeConstraint=rmCreatePieConstraint("forest edge of map", 0.5, 0.5, 0, 50, 0, 360, 0.01);
	int forestEdgeConstraint=rmCreatePieConstraint("forest edge of map", 0.5, 0.5, 0, rmGetMapXSize()-30, 0, 0, 0);
	// Player constraints
	int playerConstraint=rmCreateClassDistanceConstraint("player vs. player", classPlayer, 10.0);

   // Resource avoidance
	int forestConstraint=rmCreateClassDistanceConstraint("forest vs. things", rmClassID("classForest"), 8.0);
    int forestVsForestConstraint=rmCreateClassDistanceConstraint("forest vs. other forests", rmClassID("classForest"), 20.0);
	if ( cNumberNonGaiaPlayers < 3 )
	{
		forestVsForestConstraint=rmCreateClassDistanceConstraint("forest vs. other forests smaller", rmClassID("classForest"), 10.0);
	}
	int cottonConstraint=rmCreateClassDistanceConstraint("cotton vs. cotton", rmClassID("classCotton"), 40.0);
	int otherCottonConstraint=rmCreateClassDistanceConstraint("other things vs. cotton", rmClassID("classCotton"), 5.0);
	int playerConstraintForest=rmCreateClassDistanceConstraint("forests kinda stay away from players", classPlayer, 15.0);
	int avoidBison=rmCreateTypeDistanceConstraint("bison avoids food", "bison", 70.0);
	int avoidBighorn=rmCreateTypeDistanceConstraint("bighorn avoids food", "bighornsheep", 40.0);
	int avoidPronghorn=rmCreateTypeDistanceConstraint("pronghorn avoids food", "pronghorn", 32.0);
	int avoidFastCoin=rmCreateTypeDistanceConstraint("fast coin avoids coin", "gold", rmXFractionToMeters(0.10));
	int avoidCoin=rmCreateTypeDistanceConstraint("stuff avoids coin", "gold", 15.0);
	int coinAvoidCoin=rmCreateTypeDistanceConstraint("coin avoids coin", "gold", 60.0);
	int avoidNuggets=rmCreateClassDistanceConstraint("stuff avoids nuggets", rmClassID("nuggets"), 30.0);
	int avoidMidden=rmCreateClassDistanceConstraint("midden vrij van boompjes enzo", middenclass, 5.0);

   // Avoid impassable land
   int avoidImpassableLand=rmCreateTerrainDistanceConstraint("avoid impassable land", "Land", false, 8.0);
   int shortAvoidImpassableLand=rmCreateTerrainDistanceConstraint("short avoid impassable land", "Land", false, 2.0);
   int patchConstraint=rmCreateClassDistanceConstraint("patch vs. patch", rmClassID("classPatch"), 5.0);

   // Unit avoidance
   int avoidStartingUnits=rmCreateClassDistanceConstraint("objects avoid starting units", rmClassID("startingUnit"), 15.0);
   int avoidStartingUnitsSmall=rmCreateClassDistanceConstraint("objects avoid starting units small", rmClassID("startingUnit"), 5.0);

   // Decoration avoidance
   int avoidAll=rmCreateTypeDistanceConstraint("avoid all", "all", 6.0);

   // VP avoidance
   int avoidTradeRoute = rmCreateTradeRouteDistanceConstraint("trade route", 4.0);
   int avoidImportantItem=rmCreateClassDistanceConstraint("important stuff avoids each other", rmClassID("importantItem"), 25.0);
	int avoidImportantItemForest=rmCreateClassDistanceConstraint("important stuff avoids each forest", rmClassID("importantItem"), 10.0);

	int avoidSocket=rmCreateClassDistanceConstraint("socket avoidance", rmClassID("socketClass"), 8.0);

   // Constraint to avoid water.
   int avoidWater4 = rmCreateTerrainDistanceConstraint("avoid water", "Land", false, 4.0);
   int avoidWater20 = rmCreateTerrainDistanceConstraint("avoid water medium", "Land", false, 20.0);
   int avoidWater40 = rmCreateTerrainDistanceConstraint("avoid water long", "Land", false, 40.0);

	// Avoid the hilly areas.
	int avoidHills = rmCreateClassDistanceConstraint("avoid Hills", rmClassID("classHillArea"), 5.0);
	int avoidHillsLarge = rmCreateClassDistanceConstraint("avoid Hills by a lot", rmClassID("classHillArea"), 20.0);
	int avoidSmallHills = rmCreateClassDistanceConstraint("avoid Small Hills", rmClassID("classSmallHillArea"), 20.0);
	int avoidSmallHillsSmall = rmCreateClassDistanceConstraint("avoid Small Hills by a little", rmClassID("classSmallHillArea"), 2.0);

	// Cardinal Directions - "halves" of the map.
	int NWConstraint = rmCreateBoxConstraint("stay in NW portion", 0, 0.5, 1, 1);
	int SEConstraint = rmCreateBoxConstraint("stay in SE portion", 0, 0, 1, 0.5);
	int NEConstraint = rmCreateBoxConstraint("stay in NE portion", 0.5, 0, 1, 1);
	int SWConstraint = rmCreateBoxConstraint("stay in SW portion", 0, 0, 0.5, 1);

	int circleConstraint=rmCreatePieConstraint("circle Constraint", 0.5, 0.5, 0, rmZFractionToMeters(0.47), rmDegreesToRadians(0), rmDegreesToRadians(360));

   // Text
   rmSetStatusText("",0.10);

	// DEFINE AREAS
	// DAL TEMP: Big invisible continent, size 0.95, 0.95
   // Build up big continent called "big continent"
   int bigContinentID=rmCreateArea("big continent");
   rmSetAreaSize(bigContinentID, 0.9, 0.9); // 3 35
   rmSetAreaWarnFailure(bigContinentID, false);
   // rmSetAreaSmoothDistance(bigContinentID, 10);
	rmSetAreaMix(bigContinentID, "rockies_snow");
   rmSetAreaCoherence(bigContinentID, 0.9);
   rmSetAreaLocation(bigContinentID, 0.5, 0.5);
	rmSetAreaCliffType(bigContinentID, "rocky mountain edge");
	rmSetAreaCliffEdge(bigContinentID, 1, 1.0, 0.0, 0.0, 0);
	rmSetAreaCliffHeight(bigContinentID, -4, 1.0, 0.3);
	rmSetAreaCliffPainting(bigContinentID, false, false, true);
	rmAddAreaToClass(bigContinentID, rmClassID("classCliff"));
	rmBuildArea(bigContinentID);

   int bigContinent2ID=rmCreateArea("big continent 2");
   rmSetAreaSize(bigContinent2ID, 0.64, 0.64); // 3 35
   rmSetAreaWarnFailure(bigContinent2ID, false);
   // rmSetAreaSmoothDistance(bigContinent2ID, 10);
	rmSetAreaMix(bigContinent2ID, "rockies_snow");
   rmSetAreaCoherence(bigContinent2ID, 0.9);
   rmSetAreaLocation(bigContinent2ID, 0.5, 0.5);
	rmSetAreaCliffType(bigContinent2ID, "rocky mountain edge");
	rmSetAreaCliffEdge(bigContinent2ID, 1, 1.0, 0.0, 0.0, 0);
	rmSetAreaCliffHeight(bigContinent2ID, -8, 1.0, 0.3);
	rmSetAreaCliffPainting(bigContinent2ID, false, false, true);
	rmAddAreaToClass(bigContinent2ID, rmClassID("classCliff"));
	//rmBuildArea(bigContinent2ID);
	
	
		   //-**********************CLIFFEN******************************
   int middencliffen=rmCreateArea("cliff1");
   rmSetAreaSize(middencliffen, 0.03, 0.03);
   rmSetAreaWarnFailure(middencliffen, false);
	rmSetAreaMix(middencliffen, "rockies_snow");
   rmSetAreaCoherence(middencliffen, 1);
   rmSetAreaLocation(middencliffen, 0.05, 0.5);
 	//cliffen:
	rmSetAreaCliffType(middencliffen, "rocky mountain edge");
	rmSetAreaCliffEdge(middencliffen, 1, 1.0, 0.0, 0.0, 0);
	rmSetAreaCliffHeight(middencliffen, 4, 1.0, 0.3);
	rmSetAreaCliffPainting(middencliffen, false, false, true);
	rmBuildArea(middencliffen);
	
   int middencliffen2=rmCreateArea("cliff2");
   rmSetAreaSize(middencliffen2, 0.03, 0.03);
   rmSetAreaWarnFailure(middencliffen2, false);
	rmSetAreaMix(middencliffen2, "rockies_snow");
   rmSetAreaCoherence(middencliffen2, 1);
   rmSetAreaLocation(middencliffen2, 0.95, 0.5);
  	//cliffen:
	rmSetAreaCliffType(middencliffen2, "rocky mountain edge");
	rmSetAreaCliffEdge(middencliffen2, 1, 1.0, 0.0, 0.0, 0);
	rmSetAreaCliffHeight(middencliffen2, 4, 1.0, 0.3);
	rmSetAreaCliffPainting(middencliffen2, false, false, true);
	rmAddAreaToClass(middencliffen2, middenrij);
	rmBuildArea(middencliffen2);	
	
	
	// *********************connection***************************
	
	
	int middenmuur=rmCreateConnection("middenmuur");
	rmSetConnectionType(middenmuur, cConnectAreas, true, 1.0);
	rmAddConnectionArea(middenmuur, middencliffen);
	rmAddConnectionArea(middenmuur, middencliffen2);

	rmSetConnectionPositionVariance(middenmuur, 0.0);
	rmSetConnectionWidth(middenmuur, 20.0, 0.0);
	rmSetConnectionBaseHeight(middenmuur, 5.0);
	rmSetConnectionCoherence(middenmuur, 0.0);
	rmSetConnectionHeightBlend(middenmuur, 0.0);
	rmSetConnectionSmoothDistance(middenmuur, 0.0);
	rmAddConnectionToClass(middenmuur, middenclass);
	rmBuildConnection(middenmuur);
	
	
	
	// ***********************MUUR*********************
	float Xcoord=0.5;
	float Zcoord=0.0;
	int s=0;
	for(i=8; <392)
	{
		Zcoord = 0.01*i;
		s = rmCreateObjectDef("torentje2"+i);
		rmAddObjectDefItem(s,"SPCFortWallLarge",1,0.0);
		Xcoord=0.0025*i;
		Zcoord=0.5;
		rmPlaceObjectDefAtLoc(s, 0, Xcoord, Zcoord);
	}
	
	
	   middencliffen=rmCreateArea("cliff3");
   rmSetAreaSize(middencliffen, 0.03, 0.03);
   rmSetAreaWarnFailure(middencliffen, false);
	rmSetAreaMix(middencliffen, "rockies_snow");
   rmSetAreaCoherence(middencliffen, 1);
   rmSetAreaLocation(middencliffen, 0.05, 0.5);
 	//cliffen:
	rmSetAreaCliffType(middencliffen, "rocky mountain edge");
	rmSetAreaCliffEdge(middencliffen, 1, 1.0, 0.0, 0.0, 0);
	rmSetAreaCliffHeight(middencliffen, 4, 1.0, 0.3);
	rmSetAreaCliffPainting(middencliffen, false, false, true);
	rmBuildArea(middencliffen);
	
   middencliffen2=rmCreateArea("cliff4");
   rmSetAreaSize(middencliffen2, 0.03, 0.03);
   rmSetAreaWarnFailure(middencliffen2, false);
	rmSetAreaMix(middencliffen2, "rockies_snow");
   rmSetAreaCoherence(middencliffen2, 1);
   rmSetAreaLocation(middencliffen2, 0.95, 0.5);
  	//cliffen:
	rmSetAreaCliffType(middencliffen2, "rocky mountain edge");
	rmSetAreaCliffEdge(middencliffen2, 1, 1.0, 0.0, 0.0, 0);
	rmSetAreaCliffHeight(middencliffen2, 4, 1.0, 0.3);
	rmSetAreaCliffPainting(middencliffen2, false, false, true);
	rmBuildArea(middencliffen2);

	// DAL - end crazy wacky big continent.
   // Set up player starting locations.
   if ( cNumberTeams > 2 )
   {
		rmSetTeamSpacingModifier(0.75);
		rmSetPlacementSection(0.15, 0.85); // 0.5
	rmPlacePlayersCircular(0.35, 0.35, 0);
   }
   else
   {
		rmSetPlacementTeam(0);
		rmSetPlacementSection(0.12, 0.38);
		rmPlacePlayersLine(0.2, 0.8, 0.8, 0.8, 20, 10);
		
		rmSetPlacementTeam(1);
		rmSetPlacementSection(0.62, 0.88);
		rmPlacePlayersLine(0.8, 0.2, 0.2, 0.2, 20, 10);
   }
	//	rmPlacePlayersCircular(0.45, 0.45, rmDegreesToRadians(5.0));

    // Set up player areas.
   float playerFraction=rmAreaTilesToFraction(100);
   for(i=1; <cNumberPlayers)
   {
      // Create the area.
      int id=rmCreateArea("Player"+i);
      // Assign to the player.
      rmSetPlayerArea(i, id);
      // Set the size.
      rmSetAreaSize(id, playerFraction, playerFraction);
      rmAddAreaToClass(id, classPlayer);
      rmSetAreaMinBlobs(id, 1);
      rmSetAreaMaxBlobs(id, 1);
      rmAddAreaConstraint(id, playerConstraint); 
      rmAddAreaConstraint(id, playerEdgeConstraint); 
	  rmAddAreaConstraint(id, avoidTradeRoute); 
      rmSetAreaLocPlayer(id, i);
      rmSetAreaWarnFailure(id, false);
   }

	int numTries = -1;
	int failCount = -1;

	// Hill 2 is the central "cliffy" hill.
	int centralValleyID=rmCreateArea("center valley");
	rmSetAreaMix(centralValleyID, "rockies_grass");
	rmSetAreaTerrainType(centralValleyID, "rockies\ground4_roc");
	rmAddAreaTerrainLayer(centralValleyID, "rockies\groundsnow6_roc", 0, 2);
	rmAddAreaTerrainLayer(centralValleyID, "rockies\groundsnow7_roc", 2, 5);
	rmAddAreaTerrainLayer(centralValleyID, "rockies\groundsnow8_roc", 5, 8);
	rmSetAreaSize(centralValleyID, 0.18, 0.18);
	rmSetAreaWarnFailure(centralValleyID, false);
	rmSetAreaSmoothDistance(centralValleyID, 12);
	rmSetAreaCliffType(centralValleyID, "rocky mountain2");
	rmSetAreaCliffEdge(centralValleyID, 1, 1.0, 0.0, 0.0, 0);
	rmSetAreaCliffHeight(centralValleyID, -8, 2.0, 0.3);
	rmSetAreaCoherence(centralValleyID, 0.8);
	rmSetAreaHeightBlend(centralValleyID, 1);
	if ( cNumberTeams == 2 )
	{
		rmAddAreaCliffWaypoint(centralValleyID, 0.5, 0.2);
		rmAddAreaCliffRandomWaypoints(centralValleyID, 0.5, 0.8, 8, 20.0);
	}
	else
	{
		rmAddAreaCliffWaypoint(centralValleyID, 0.5, 0.35);
		rmAddAreaCliffRandomWaypoints(centralValleyID, 0.5, 0.65, 8, 20.0);
	}
	rmSetAreaCliffPainting(centralValleyID, true, false, true);
	rmAddAreaToClass(centralValleyID, rmClassID("classHillArea"));
	//rmBuildArea(centralValleyID);

   // Text
   rmSetStatusText("",0.20);

 


   // Text
   rmSetStatusText("",0.30);

   // NATIVE AMERICANS
	int lakotaVillageAID = -1;
	int lakotaVillageType = rmRandInt(1,5);
	if ( whichNative == 1 )
	{
		lakotaVillageAID = rmCreateGrouping("lakota village A", "native lakota village "+lakotaVillageType);
	}
	else
	{
		lakotaVillageAID = rmCreateGrouping("comanche village A", "native comanche village "+lakotaVillageType);
	}
	rmSetGroupingMinDistance(lakotaVillageAID, 0.0);
	rmSetGroupingMaxDistance(lakotaVillageAID, 0.0);
	rmAddGroupingConstraint(lakotaVillageAID, avoidImpassableLand);
	rmAddGroupingToClass(lakotaVillageAID, rmClassID("importantItem"));
	rmAddGroupingConstraint(lakotaVillageAID, avoidTradeRoute);
	rmPlaceGroupingAtLoc(lakotaVillageAID, 0, 0.2, 0.5);

	// Text
   rmSetStatusText("",0.40);

	int lakotaVillageBID = -1;
	lakotaVillageType = rmRandInt(1,5);
	if ( whichNative == 1 )
	{
		lakotaVillageBID = rmCreateGrouping("lakota village B", "native lakota village "+lakotaVillageType);
	}
	else
	{
		lakotaVillageBID = rmCreateGrouping("comanche village B", "native comanche village "+lakotaVillageType);
	}
	rmSetGroupingMinDistance(lakotaVillageBID, 0.0);
	rmSetGroupingMaxDistance(lakotaVillageBID, 0.0);
	rmAddGroupingConstraint(lakotaVillageBID, avoidImpassableLand);
	rmAddGroupingToClass(lakotaVillageBID, rmClassID("importantItem"));
	rmAddGroupingConstraint(lakotaVillageBID, avoidTradeRoute);
	rmPlaceGroupingAtLoc(lakotaVillageBID, 0, 0.8, 0.5);

	// Text
   rmSetStatusText("",0.60);

    //STARTING UNITS
   	int startingTCID= rmCreateObjectDef("startingTC");
	if ( rmGetNomadStart())
	{
		rmAddObjectDefItem(startingTCID, "CoveredWagon", 1, 0.0);
	}
	else
	{
		rmAddObjectDefItem(startingTCID, "TownCenter", 1, 0.0);
	}
	rmAddObjectDefToClass(startingTCID, rmClassID("startingUnit"));
	rmAddObjectDefConstraint(startingTCID, avoidTradeRoute);
	rmSetObjectDefMinDistance(startingTCID, 0.0);
	rmSetObjectDefMaxDistance(startingTCID, 16.0);

   int startingUnits = rmCreateStartingUnitsObjectDef(5.0);
	rmSetObjectDefMinDistance(startingUnits, 5.0);
	rmSetObjectDefMaxDistance(startingUnits, 8.0);
	rmAddObjectDefConstraint(startingUnits, avoidStartingUnitsSmall);
	
	int StartAreaTreeID=rmCreateObjectDef("starting trees");
	rmAddObjectDefItem(StartAreaTreeID, "TreeRockiesSnow", 1, 0.0);
	rmSetObjectDefMinDistance(StartAreaTreeID, 12.0);
	rmSetObjectDefMaxDistance(StartAreaTreeID, 20.0);
	rmAddObjectDefConstraint(StartAreaTreeID, avoidStartingUnitsSmall);

	int StartBighornID=rmCreateObjectDef("starting bighorn");
	rmAddObjectDefItem(StartBighornID, "bighornsheep", 5, 4.0);
	rmSetObjectDefMinDistance(StartBighornID, 9.0);
	rmSetObjectDefMaxDistance(StartBighornID, 13.0);
	rmSetObjectDefCreateHerd(StartBighornID, true);
	rmAddObjectDefConstraint(StartBighornID, avoidStartingUnitsSmall);

	int playerNuggetID=rmCreateObjectDef("player nugget");
	rmAddObjectDefItem(playerNuggetID, "nugget", 1, 0.0);
	rmAddObjectDefToClass(playerNuggetID, rmClassID("nuggets"));
	rmAddObjectDefToClass(playerNuggetID, rmClassID("startingUnit"));
    rmSetObjectDefMinDistance(playerNuggetID, 30.0);
    rmSetObjectDefMaxDistance(playerNuggetID, 35.0);
	rmAddObjectDefConstraint(playerNuggetID, avoidStartingUnitsSmall);
	rmAddObjectDefConstraint(playerNuggetID, avoidTradeRoute);
	rmAddObjectDefConstraint(playerNuggetID, avoidNuggets);
	rmAddObjectDefConstraint(playerNuggetID, forestEdgeConstraint);	// Pushing the nuggets away from the cliffs at the edge.
	rmAddObjectDefConstraint(playerNuggetID, circleConstraint);

	int playerGoldID=rmCreateObjectDef("player silver ore");
	int silverType = rmRandInt(1,10);

 	for(i=1; <cNumberPlayers)
	{
		rmPlaceObjectDefAtLoc(startingTCID, i, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(startingUnits, i, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		// vector closestPoint=rmGetUnitPosition(rmGetUnitPlacedOfPlayer(startingUnits, i));
		// rmSetHomeCityGatherPoint(i, closestPoint);

		// Everyone gets two ore groupings, one pretty close, the other a little further away.
		silverType = rmRandInt(1,10);
		playerGoldID = rmCreateObjectDef("player silver closer "+i);
		rmAddObjectDefItem(playerGoldID, "mine", 1, 0.0);
		// rmAddGroupingToClass(playerGoldID, rmClassID("importantItem"));
		rmAddObjectDefConstraint(playerGoldID, avoidTradeRoute);
		rmAddObjectDefConstraint(playerGoldID, avoidStartingUnitsSmall);
		rmAddObjectDefConstraint(playerGoldID, avoidMidden);
		rmSetObjectDefMinDistance(playerGoldID, 15.0);
		rmSetObjectDefMaxDistance(playerGoldID, 20.0);
		rmPlaceObjectDefAtLoc(playerGoldID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));

		// Placing starting Pronghorns...
		rmPlaceObjectDefAtLoc(StartBighornID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		// rmPlaceObjectDefAtLoc(StartBighornID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		// rmPlaceObjectDefAtLoc(StartBighornID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		// rmPlaceObjectDefAtLoc(StartBighornID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		
		// Placing starting trees...
		rmPlaceObjectDefAtLoc(StartAreaTreeID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(StartAreaTreeID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(StartAreaTreeID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(StartAreaTreeID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(StartAreaTreeID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(StartAreaTreeID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(StartAreaTreeID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(StartAreaTreeID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));

		// Nuggets
		rmSetNuggetDifficulty(1, 1);
		rmPlaceObjectDefAtLoc(playerNuggetID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(playerNuggetID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
	}

	// Text

	// Place resources - silver mines in the east
	silverType = rmRandInt(1,10);
	int silverID = -1;
	int silver2ID = -1;
	int silver3ID = -1;
	int silverCount = cNumberNonGaiaPlayers;

	rmEchoInfo("silver count = "+silverCount);
	for(i=0; < silverCount)
	{
		silverType = rmRandInt(1,10);
		silverID = rmCreateObjectDef("silver "+i);
		rmAddObjectDefItem(silverID, "mine", 1, 0.0);
		rmSetObjectDefMinDistance(silverID, 0.0);
		rmSetObjectDefMaxDistance(silverID, rmXFractionToMeters(0.5));

		rmAddObjectDefConstraint(silverID, playerConstraint);
		rmAddObjectDefConstraint(silverID, coinAvoidCoin);
		rmAddObjectDefConstraint(silverID, avoidImpassableLand);
		rmAddObjectDefConstraint(silverID, avoidTradeRoute);
		rmAddObjectDefConstraint(silverID, avoidSocket);
		rmAddObjectDefConstraint(silverID, avoidHillsLarge);
		rmAddObjectDefConstraint(silverID, SWConstraint);
		rmAddObjectDefConstraint(silverID, silverEdgeConstraint);
		rmAddObjectDefConstraint(silverID, avoidStartingUnits);
		rmAddObjectDefConstraint(silverID, avoidMidden);
		rmPlaceObjectDefAtLoc(silverID, 0, 0.5, 0.5);
	}

	// Silver in the west
	for(i=0; < silverCount)
	{
		silverType = rmRandInt(1,10);
		silver2ID = rmCreateObjectDef("silver north "+i);
		rmAddObjectDefItem(silver2ID, "mine", 1, 0.0);
		rmSetObjectDefMinDistance(silver2ID, 0.0);
		rmSetObjectDefMaxDistance(silver2ID, rmXFractionToMeters(0.5));
		rmAddObjectDefConstraint(silver2ID, avoidMidden);
		rmAddObjectDefConstraint(silver2ID, playerConstraint);
		rmAddObjectDefConstraint(silver2ID, coinAvoidCoin);
		rmAddObjectDefConstraint(silver2ID, avoidImpassableLand);
		rmAddObjectDefConstraint(silver2ID, avoidTradeRoute);
		rmAddObjectDefConstraint(silver2ID, avoidSocket);
		rmAddObjectDefConstraint(silver2ID, avoidHillsLarge);
		rmAddObjectDefConstraint(silver2ID, NEConstraint);
		rmAddObjectDefConstraint(silver2ID, silverEdgeConstraint);
		rmAddObjectDefConstraint(silver2ID, avoidStartingUnits);
		rmPlaceObjectDefAtLoc(silver2ID, 0, 0.5, 0.5);
	}

	// Text
   rmSetStatusText("",0.70); 

	// Then a few more in the middle, clustered and away from the edges
	for(i=0; < silverCount)
	{
		silverType = rmRandInt(1,10);
		silver3ID = rmCreateObjectDef("silver south "+i);
		rmAddObjectDefItem(silver3ID, "mine", 1, 0.0);
		rmSetObjectDefMinDistance(silver3ID, 0.0);
		rmSetObjectDefMaxDistance(silver3ID, rmXFractionToMeters(0.5));

		rmAddObjectDefConstraint(silver3ID, coinAvoidCoin);
		rmAddObjectDefConstraint(silver3ID, avoidImpassableLand);
		rmAddObjectDefConstraint(silver3ID, avoidTradeRoute);
		rmAddObjectDefConstraint(silver3ID, avoidSocket);
		rmAddObjectDefConstraint(silver3ID, avoidMidden);
		rmAddObjectDefConstraint(silver3ID, silverEdgeConstraint);
		rmPlaceObjectDefInArea(silver3ID, 0, centralValleyID);
	}
   // Text
   rmSetStatusText("",0.80);

	// Define and place forests - west and east
	int forestTreeID = 0;
	
	numTries=2*cNumberNonGaiaPlayers;  // DAL - 3 here, 3 below
	failCount=0;
	for (i=0; <numTries)
	{   
		int westForest=rmCreateArea("westForest"+i);
		rmSetAreaWarnFailure(westForest, false);
		rmAddAreaToClass(westForest, rmClassID("classForest"));
		rmSetAreaSize(westForest, rmAreaTilesToFraction(150), rmAreaTilesToFraction(200));
		rmSetAreaForestType(westForest, "rockies snow forest");
		rmSetAreaForestDensity(westForest, 0.9);
		rmSetAreaForestClumpiness(westForest, 0.3);					//DAL more forest with more clumps
		rmSetAreaForestUnderbrush(westForest, 0.0);
		rmSetAreaCoherence(westForest, 0.3);
		rmSetAreaSmoothDistance(westForest, 10);
		rmSetAreaObeyWorldCircleConstraint(westForest, false);
		rmAddAreaConstraint(westForest, avoidImportantItemForest);		// DAL added, to try and make sure natives got on the map w/o override.
		rmAddAreaConstraint(westForest, playerConstraintForest);	// DAL adeed, to keep forests away from the player.
		rmAddAreaConstraint(westForest, forestVsForestConstraint);			// DAL adeed, to keep forests away from each other.
		rmAddAreaConstraint(westForest, SWConstraint);				// DAL adeed, to keep these forests in the west.
		rmAddAreaConstraint(westForest, avoidTradeRoute);
		rmAddAreaConstraint(westForest, avoidHills);
		rmAddAreaConstraint(westForest, avoidSocket);
		rmAddAreaConstraint(westForest, avoidCoin);
		rmAddAreaConstraint(westForest, forestEdgeConstraint);
		rmAddAreaConstraint(westForest, avoidStartingUnits);
		rmAddAreaConstraint(westForest, avoidMidden);
		if(rmBuildArea(westForest)==false)
		{
			// Stop trying once we fail 5 times in a row.
			failCount++;
			if(failCount==5)
				break;
		}
		else
			failCount=0; 
	}

	numTries=2*cNumberNonGaiaPlayers;  // DAL - 3 here, 3 above
	failCount=0;
	for (i=0; <numTries)
	{   
		int eastForest=rmCreateArea("eastForest"+i);
		rmSetAreaWarnFailure(eastForest, false);
		rmAddAreaToClass(eastForest, rmClassID("classForest"));
		rmSetAreaSize(eastForest, rmAreaTilesToFraction(150), rmAreaTilesToFraction(200));
		rmSetAreaForestType(eastForest, "rockies snow forest");
		rmSetAreaForestDensity(eastForest, 0.9);
		rmSetAreaForestClumpiness(eastForest, 0.3);						//DAL more forest with more clumps
		rmSetAreaForestUnderbrush(eastForest, 0.0);
		rmSetAreaCoherence(eastForest, 0.3);
		rmSetAreaSmoothDistance(eastForest, 10);
		rmSetAreaObeyWorldCircleConstraint(eastForest, false);
		rmAddAreaConstraint(eastForest, avoidImportantItemForest);	// DAL added, to try and make sure natives got on the map w/o override.
		rmAddAreaConstraint(eastForest, playerConstraintForest);		// DAL adeed, to keep forests away from the player.
		rmAddAreaConstraint(eastForest, forestVsForestConstraint);				// DAL adeed, to keep forests away from each other.
		rmAddAreaConstraint(eastForest, NEConstraint);	// DAL adeed, to keep these forests in the east.
		rmAddAreaConstraint(eastForest, avoidTradeRoute);
		rmAddAreaConstraint(eastForest, avoidHills);
		rmAddAreaConstraint(eastForest, avoidSocket);
		rmAddAreaConstraint(eastForest, avoidCoin);
		rmAddAreaConstraint(eastForest, forestEdgeConstraint);
		rmAddAreaConstraint(eastForest, avoidStartingUnits);
		rmAddAreaConstraint(eastForest, avoidMidden);
		if(rmBuildArea(eastForest)==false)
		{
			// Stop trying once we fail 5 times in a row.
			failCount++;
			if(failCount==5)
				break;
		}
		else
			failCount=0;
	} 

	numTries=cNumberNonGaiaPlayers;															// DAL - 1 more forests/player in the middle.
	failCount=0;
	for (i=0; <numTries)
	{   
		int centerForest=rmCreateArea("centerForest"+i, centralValleyID);
		rmSetAreaWarnFailure(centerForest, false);
		rmAddAreaToClass(centerForest, rmClassID("classForest"));
		rmSetAreaSize(centerForest, rmAreaTilesToFraction(500), rmAreaTilesToFraction(600));
		rmSetAreaForestType(centerForest, "rockies forest");
		rmSetAreaForestDensity(centerForest, 0.9);
		rmSetAreaForestClumpiness(centerForest, 0.7);										// DAL more forest with more clumps
		rmSetAreaForestUnderbrush(centerForest, 0.0);
		rmSetAreaCoherence(centerForest, 0.7);												// DAL forests in the valley are more coherent
		rmSetAreaSmoothDistance(centerForest, 10);
		rmSetAreaObeyWorldCircleConstraint(centerForest, false);
		rmAddAreaConstraint(centerForest, forestVsForestConstraint);						// DAL adeed, to keep forests away from each other.
		rmAddAreaConstraint(centerForest, avoidSocket);
		rmAddAreaConstraint(centerForest, avoidTradeRoute);
		rmAddAreaConstraint(centerForest, avoidMidden);
		rmAddAreaConstraint(centerForest, avoidCoin);
		if(rmBuildArea(centerForest)==false)
		{
			// Stop trying once we fail 5 times in a row.
			failCount++;
			if(failCount==5)
				break;
		}
		else
			failCount=0;
	} 

	rmSetStatusText("",0.90);

	// bighorn - two groups (one on each side per player)
	int bighorn1ID=rmCreateObjectDef("bighorn herd 1");
	rmAddObjectDefItem(bighorn1ID, "BighornSheep", rmRandInt(6,8), 10.0);
	rmSetObjectDefMinDistance(bighorn1ID, 0.0);
	rmSetObjectDefMaxDistance(bighorn1ID, rmXFractionToMeters(0.5));
	rmAddObjectDefConstraint(bighorn1ID, avoidBighorn);
	rmAddObjectDefConstraint(bighorn1ID, avoidImpassableLand);
	rmAddObjectDefConstraint(bighorn1ID, avoidTradeRoute);
	rmAddObjectDefConstraint(bighorn1ID, avoidSocket);
	rmAddObjectDefConstraint(bighorn1ID, forestConstraint);
	rmAddObjectDefConstraint(bighorn1ID, SWConstraint);
	rmAddObjectDefConstraint(bighorn1ID, avoidHills);
	rmAddObjectDefConstraint(bighorn1ID, avoidCoin);
	rmAddObjectDefConstraint(bighorn1ID, avoidMidden);
	rmAddObjectDefConstraint(bighorn1ID, avoidStartingUnits);
	rmSetObjectDefCreateHerd(bighorn1ID, true);
	rmPlaceObjectDefAtLoc(bighorn1ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers);

	int bighorn2ID=rmCreateObjectDef("bighorn herd 2");
	rmAddObjectDefItem(bighorn2ID, "BighornSheep", rmRandInt(6,8), 10.0);
	rmSetObjectDefMinDistance(bighorn2ID, 0.0);
	rmSetObjectDefMaxDistance(bighorn2ID, rmXFractionToMeters(0.5));
	rmAddObjectDefConstraint(bighorn2ID, avoidBighorn);
	rmAddObjectDefConstraint(bighorn2ID, avoidImpassableLand);
	rmAddObjectDefConstraint(bighorn2ID, avoidTradeRoute);
	rmAddObjectDefConstraint(bighorn2ID, avoidSocket);
	rmAddObjectDefConstraint(bighorn2ID, forestConstraint);
	rmAddObjectDefConstraint(bighorn2ID, NEConstraint);
	rmAddObjectDefConstraint(bighorn2ID, avoidHills);
	rmAddObjectDefConstraint(bighorn2ID, avoidMidden);
	rmAddObjectDefConstraint(bighorn2ID, avoidCoin);
	rmAddObjectDefConstraint(bighorn2ID, avoidStartingUnits);
	rmSetObjectDefCreateHerd(bighorn2ID, true);
	rmPlaceObjectDefAtLoc(bighorn2ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers);

	// pronghorn sheep down in the (center) valley
	int pronghornID=rmCreateObjectDef("pronghorn Herd");
	rmAddObjectDefItem(pronghornID, "pronghorn", rmRandInt(8,10), 10.0);
	rmSetObjectDefMinDistance(pronghornID, 0.0);
	rmSetObjectDefMaxDistance(pronghornID, rmXFractionToMeters(0.5));
	rmAddObjectDefConstraint(pronghornID, avoidPronghorn);
	rmAddObjectDefConstraint(pronghornID, avoidImpassableLand);
	rmAddObjectDefConstraint(pronghornID, avoidTradeRoute);
	rmAddObjectDefConstraint(pronghornID, forestConstraint);
	rmAddObjectDefConstraint(pronghornID, avoidSocket);
	rmAddObjectDefConstraint(pronghornID, avoidMidden);
	rmAddObjectDefConstraint(pronghornID, avoidSmallHillsSmall);
	// rmSetObjectDefCreateHerd(pronghornID, true);
	rmPlaceObjectDefInArea(pronghornID, 0, centralValleyID, cNumberNonGaiaPlayers*3);
		
	// Define and place Nuggets - mostly in the middle section.
	int nuggetID = 0;

	// Nuggets in the center.
	for(i=0; <cNumberNonGaiaPlayers*4)
	{
		rmSetNuggetDifficulty(1, 3);
		nuggetID= rmCreateObjectDef("nugget center "+i); 
		rmAddObjectDefItem(nuggetID, "Nugget", 1, 0.0);
		rmSetObjectDefMinDistance(nuggetID, 0.0);
		rmSetObjectDefMaxDistance(nuggetID, rmXFractionToMeters(0.5));
		rmAddObjectDefConstraint(nuggetID, avoidImpassableLand);
		rmAddObjectDefToClass(nuggetID, rmClassID("nuggets"));
		rmAddObjectDefConstraint(nuggetID, avoidImportantItem);
		rmAddObjectDefConstraint(nuggetID, avoidNuggets);
		rmAddObjectDefConstraint(nuggetID, avoidCoin);
		rmAddObjectDefConstraint(nuggetID, otherCottonConstraint);
		rmAddObjectDefConstraint(nuggetID, avoidTradeRoute);
		rmAddObjectDefConstraint(nuggetID, avoidSmallHillsSmall);
		rmAddObjectDefConstraint(nuggetID, forestEdgeConstraint);
		rmAddObjectDefConstraint(nuggetID, avoidMidden);
		rmAddObjectDefConstraint(nuggetID, circleConstraint);
		rmPlaceObjectDefInArea(nuggetID, 0, centralValleyID, 1);
	}

	/*
	// Nuggets - one per player in each of the non-hill sections.
	// DAL - these taken out, now only player nuggets + ones in center
	for(i=0; <cNumberNonGaiaPlayers*2)
	{
		nuggetID= rmCreateObjectDef("nugget southwest "+i); 
		rmAddObjectDefItem(nuggetID, "Nugget", 1, 0.0);
		rmSetObjectDefMinDistance(nuggetID, 0.0);
		rmSetObjectDefMaxDistance(nuggetID, rmXFractionToMeters(0.5));
		rmAddObjectDefConstraint(nuggetID, avoidImpassableLand);
		rmAddObjectDefToClass(nuggetID, rmClassID("nuggets"));
		rmAddObjectDefConstraint(nuggetID, avoidImportantItem);
		rmAddObjectDefConstraint(nuggetID, avoidNuggets);
		rmAddObjectDefConstraint(nuggetID, avoidCoin);
		rmAddObjectDefConstraint(nuggetID, avoidTradeRoute);
		rmAddObjectDefConstraint(nuggetID, avoidHills);
		rmAddObjectDefConstraint(nuggetID, SWConstraint);
		rmAddObjectDefConstraint(nuggetID, avoidStartingUnits);
		rmPlaceObjectDefAtLoc(nuggetID, 0, 0.5, 0.5, 1);

	}
	for(i=0; <cNumberNonGaiaPlayers*2)
	{
		nuggetID= rmCreateObjectDef("nugget northeast "+i); 
		rmAddObjectDefItem(nuggetID, "Nugget", 1, 0.0);
		rmSetObjectDefMinDistance(nuggetID, 0.0);
		rmSetObjectDefMaxDistance(nuggetID, rmXFractionToMeters(0.5));
		rmAddObjectDefConstraint(nuggetID, avoidImpassableLand);
		rmAddObjectDefToClass(nuggetID, rmClassID("nuggets"));
		rmAddObjectDefConstraint(nuggetID, avoidImportantItem);
		rmAddObjectDefConstraint(nuggetID, avoidNuggets);
		rmAddObjectDefConstraint(nuggetID, avoidCoin);
		rmAddObjectDefConstraint(nuggetID, avoidHills);
		rmAddObjectDefConstraint(nuggetID, NEConstraint);
		rmAddObjectDefConstraint(nuggetID, avoidStartingUnits);
		rmPlaceObjectDefAtLoc(nuggetID, 0, 0.5, 0.5, 1);
	}
	*/

   // Text
   
   	rmCreateTrigger("modproto");
	rmAddTriggerEffect("Modify Protounit");
	rmSetTriggerEffectParam("ProtoUnit", "SPCFortWallLarge");
	rmSetTriggerEffectParamInt("PlayerID", 0);
	rmSetTriggerEffectParamInt("Field", 0);
	rmSetTriggerEffectParamFloat("Delta", 100000000.0);
	rmSetTriggerPriority(1);
	rmSetTriggerActive(true);
	rmSetTriggerRunImmediately(true);
	rmSetTriggerLoop(false);
	
	
	rmCreateTrigger("opblazen");
	rmSwitchToTrigger(rmTriggerID("opblazen"));		
	rmAddTriggerCondition("Timer");
	rmSetTriggerConditionParamInt("Param1",15*60); // 20 is the NR timer (in minutes). You are allowed to change it, but: ALSO CHANGE MAP NAME AND DESCRIPTION TO NEW TIMER, and dont say you made the map, you changed the timer, i made the map
	rmAddTriggerEffect("Modify Protounit");
	rmSetTriggerEffectParam("ProtoUnit", "SPCFortWallLarge");
	rmSetTriggerEffectParamInt("PlayerID", 0);
	rmSetTriggerEffectParamInt("Field", 0);
	rmSetTriggerEffectParamFloat("Delta", -100000000.0);
	rmSetTriggerPriority(1);
	rmSetTriggerActive(true);
	rmSetTriggerRunImmediately(true);
	rmSetTriggerLoop(false);
	
	
	rmSetStatusText("",1.0);
   
}