// BAYOU Joes revision

// Main entry point for random map script
include "mercenaries.xs";
void main(void)
{

   // Text
   // These status text lines are used to manually animate the map generation progress bar
   rmSetStatusText("",0.01);

   int subCiv0=-1;
   int subCiv1=-1;
   int subCiv2=-1;
   int subCiv3=-1;
   int subCiv4=-1;

  

   // Picks the map size
   int playerTiles=160000;
   int size=2.0*sqrt(cNumberNonGaiaPlayers*playerTiles);
   rmEchoInfo("Map size="+size+"m x "+size+"m");
   rmSetMapSize(1100, 1100);

   // Picks a default water height
   rmSetSeaLevel(2.0);

   // Picks default terrain and water

// rmSetMapElevationParameters(long type, float minFrequency, long numberOctaves, float persistence, float heightVariation)
//	rmSetMapElevationParameters(cElevTurbulence, 0.1, 4, 0.3, 2.0);
	rmSetSeaType("atlantic coast");
   rmEnableLocalWater(false);
	rmSetBaseTerrainMix("amazon_grass");
   rmTerrainInitialize("water");
	rmSetMapType("water");
//	rmSetMapType("grass");
	rmSetWorldCircleConstraint(true);


	// Choose mercs.
	chooseMercs();

   // Define some classes. These are used later for constraints.
   int classPlayer=rmDefineClass("player");
   rmDefineClass("classCliff");
   rmDefineClass("classPatch");
	rmDefineClass("starting settlement");
   int classbigContinent=rmDefineClass("big continent");
   rmDefineClass("classForest");
   rmDefineClass("importantItem");
	rmDefineClass("secrets");
	int classBay=rmDefineClass("bay");

   int classIsland=rmDefineClass("island");
   int classBonusIsland=rmDefineClass("bonus island");
   int classSideIsland=rmDefineClass("side island");
   rmDefineClass("corner");



   // -------------Define constraints
   // These are used to have objects and areas avoid each other
   
   // Map edge constraints
   int playerEdgeConstraint=rmCreateBoxConstraint("player edge of map", rmXTilesToFraction(20), rmZTilesToFraction(20), 1.0-rmXTilesToFraction(20), 1.0-rmZTilesToFraction(20), 0.01);
   int longPlayerConstraint=rmCreateClassDistanceConstraint("continent stays away from players", classPlayer, 40.0);

   // Player constraints
	int islandConstraint=rmCreateClassDistanceConstraint("stay away from islands", classIsland, 0.0);
	int playerConstraint=rmCreateClassDistanceConstraint("bonus Settlement stay away from players", classPlayer, 20);
	int bonusIslandConstraint=rmCreateClassDistanceConstraint("avoid bonus island", classBonusIsland, 10.0);
	int longBonusIslandConstraint=rmCreateClassDistanceConstraint("long avoid bonus island", classBonusIsland, 30.0);
	int whaleVsWhaleID=rmCreateTypeDistanceConstraint("whale v whale", "HumpbackWhale", 50.0);
    int whaleLand = rmCreateTerrainDistanceConstraint("whale land", "land", true, 25.0);
	int longSideIslandConstraint=rmCreateClassDistanceConstraint("long avoid side island", classSideIsland, 30.0);
	int cornerConstraint=rmCreateClassDistanceConstraint("stay away from corner", rmClassID("corner"), 15.0);
	int cornerOverlapConstraint=rmCreateClassDistanceConstraint("don't overlap corner", rmClassID("corner"), 2.0);
	int bayConstraint=rmCreateClassDistanceConstraint("avoid bay", classBay, 3);

	int smallMapPlayerConstraint=rmCreateClassDistanceConstraint("stay away from players a lot", classPlayer, 70.0);
	int flagConstraint=rmCreateHCGPConstraint("flags avoid same", 30.0);
	int nearWater10 = rmCreateTerrainDistanceConstraint("near water", "Water", true, 10.0);
	int avoidBoats=rmCreateTypeDistanceConstraint("avoid boats", "fluyt", 30.0);

	// Bonus area constraint.
	 int bigContinentConstraint=rmCreateClassDistanceConstraint("avoid big island", classbigContinent, 20.0);

	// Resource avoidance
	int forestConstraint=rmCreateClassDistanceConstraint("forest vs. forest", rmClassID("classForest"), 30.0);
	int avoidStartResource=rmCreateTypeDistanceConstraint("start resource no overlap", "resource", 1.0);
	int avoidCoin=rmCreateTypeDistanceConstraint("avoid coin", "gold", 50.0);
	int farAvoidCoin=rmCreateTypeDistanceConstraint("silver avoid coin", "gold", 70.0);
	int avoidNugget=rmCreateTypeDistanceConstraint("nugget avoid nugget", "nugget", 200.0);
	int avoidbison=rmCreateTypeDistanceConstraint("food avoids food", "bison", 80.0);
	int avoidrhea=rmCreateTypeDistanceConstraint("avoid rheas", "rhea", 50.0);
	int avoidCotton=rmCreateTypeDistanceConstraint("avoid cotton", "cotton", 50.0);
	int fishVsFishID=rmCreateTypeDistanceConstraint("fish v fish", "fish", 18.0);
	int fishLand = rmCreateTerrainDistanceConstraint("fish land", "land", true, 6.0);

   // Avoid impassable land
   int avoidImpassableLand=rmCreateTerrainDistanceConstraint("avoid impassable land", "Land", false, 10.0);
   int shortAvoidImpassableLand=rmCreateTerrainDistanceConstraint("short avoid impassable land", "Land", false, 1.0);
   int avoidCliffs=rmCreateClassDistanceConstraint("cliff vs. cliff", rmClassID("classCliff"), 30.0);
   int patchConstraint=rmCreateClassDistanceConstraint("patch vs. patch", rmClassID("classPatch"), 5.0);

   // Decoration avoidance
   int avoidAll=rmCreateTypeDistanceConstraint("avoid all", "all", 6.0);

   // VP avoidance
   int avoidImportantItem = rmCreateClassDistanceConstraint("secrets etc avoid each other", rmClassID("importantItem"), 80.0);

   // Constraint to avoid water.
   int avoidWater8 = rmCreateTerrainDistanceConstraint("avoid water long", "Land", false, 8.0);


  // Text
   rmSetStatusText("",0.10);


	 // Create center section
   int centerIslandID=rmCreateArea("Center Island area");
   rmSetAreaSize(centerIslandID, 0.06, 0.5);
   rmSetAreaLocation(centerIslandID, 0.5, 0.5);
   rmSetAreaMix(centerIslandID, "amazon_grass");
   rmSetAreaBaseHeight(centerIslandID, 4.0); // Was 10
   rmSetAreaMinBlobs(centerIslandID, 25);
   rmSetAreaMaxBlobs(centerIslandID, 30);
   rmSetAreaMinBlobDistance(centerIslandID, 10);
   rmSetAreaMaxBlobDistance(centerIslandID, 20);
   rmSetAreaSmoothDistance(centerIslandID, 50);
   rmSetAreaCoherence(centerIslandID, 0.50);
	rmAddAreaToClass(centerIslandID, rmClassID("bay"));
   rmSetAreaObeyWorldCircleConstraint(centerIslandID, false);
    rmBuildArea(centerIslandID);

//  ********************************** Island fingers *******************************
   
      int bonusIsland1ID=rmCreateArea("bonus island 1");
      rmSetAreaSize(bonusIsland1ID, 0.04, 0.04);
	  rmSetAreaLocation(bonusIsland1ID, 0.23, 0.5);
      rmSetAreaMix(bonusIsland1ID, "amazon_ grass");
      rmSetAreaWarnFailure(bonusIsland1ID, false);
    //  if(rmRandFloat(0.0, 1.0)<0.70)
      rmAddAreaConstraint(bonusIsland1ID, bonusIslandConstraint);
      rmAddAreaToClass(bonusIsland1ID, classIsland);
      rmAddAreaToClass(bonusIsland1ID, classBonusIsland);
      //rmAddAreaConstraint(bonusIsland1ID, bayConstraint);
	  //rmAddAreaConstraint(bonusIsland1ID, playerEdgeConstraint);
      rmSetAreaCoherence(bonusIsland1ID, 0.25);
      rmSetAreaSmoothDistance(bonusIsland1ID, 12);
	  rmSetAreaElevationType(bonusIsland1ID, cElevTurbulence);
	  rmSetAreaElevationVariation(bonusIsland1ID, 2.0);
		rmSetAreaBaseHeight(bonusIsland1ID, 4.0);
		rmSetAreaElevationMinFrequency(bonusIsland1ID, 0.09);
		rmSetAreaElevationOctaves(bonusIsland1ID, 3);
		rmSetAreaElevationPersistence(bonusIsland1ID, 0.2);      
  
int bonusIsland2ID=rmCreateArea("bonus island 2");
      rmSetAreaSize(bonusIsland2ID, 0.04, 0.04);
	  rmSetAreaLocation(bonusIsland2ID, 0.4, 0.30);
      rmSetAreaMix(bonusIsland2ID, "amazon_grass");
      rmSetAreaWarnFailure(bonusIsland2ID, false);
    //  if(rmRandFloat(0.0, 1.0)<0.70)
      rmAddAreaConstraint(bonusIsland2ID, bonusIslandConstraint);
      rmAddAreaToClass(bonusIsland2ID, classIsland);
      rmAddAreaToClass(bonusIsland2ID, classBonusIsland);
     // rmAddAreaConstraint(bonusIsland2ID, bayConstraint);
	 // rmAddAreaConstraint(bonusIsland2ID, playerEdgeConstraint);
      rmSetAreaCoherence(bonusIsland2ID, 0.25);
      rmSetAreaSmoothDistance(bonusIsland2ID, 12);
	  rmSetAreaElevationType(bonusIsland2ID, cElevTurbulence);
		rmSetAreaElevationVariation(bonusIsland2ID, 2.0);
		rmSetAreaBaseHeight(bonusIsland2ID, 4.0);
		rmSetAreaElevationMinFrequency(bonusIsland2ID, 0.09);
		rmSetAreaElevationOctaves(bonusIsland2ID, 3);
		rmSetAreaElevationPersistence(bonusIsland2ID, 0.1);     

		int bonusIsland3ID=rmCreateArea("bonus island 3");
      rmSetAreaSize(bonusIsland3ID, 0.025, 0.04);
	  rmSetAreaLocation(bonusIsland3ID, 0.4, 0.75);
      rmSetAreaMix(bonusIsland3ID, "amazon_grass");
      rmSetAreaWarnFailure(bonusIsland3ID, false);
    //  if(rmRandFloat(0.0, 1.0)<0.70)
      rmAddAreaConstraint(bonusIsland3ID, bonusIslandConstraint);
      rmAddAreaToClass(bonusIsland3ID, classIsland);
      rmAddAreaToClass(bonusIsland3ID, classBonusIsland);
      //rmAddAreaConstraint(bonusIsland3ID, bayConstraint);
	  //rmAddAreaConstraint(bonusIsland3ID, playerEdgeConstraint);
      rmSetAreaCoherence(bonusIsland3ID, 0.25);
      rmSetAreaSmoothDistance(bonusIsland3ID, 12);
	  rmSetAreaElevationType(bonusIsland3ID, cElevTurbulence);
		rmSetAreaElevationVariation(bonusIsland3ID, 2.0);
		rmSetAreaBaseHeight(bonusIsland3ID, 4.0);
		rmSetAreaElevationMinFrequency(bonusIsland3ID, 0.09);
		rmSetAreaElevationOctaves(bonusIsland3ID, 3);
		rmSetAreaElevationPersistence(bonusIsland3ID, 0.2);     


		rmSetStatusText("",0.20);


		int bonusIsland4ID=rmCreateArea("bonus island 4");
      rmSetAreaSize(bonusIsland4ID, 0.04, 0.04);
	  rmSetAreaLocation(bonusIsland4ID, 0.75, 0.5);
      rmSetAreaMix(bonusIsland4ID, "amazon_grass");
      rmSetAreaWarnFailure(bonusIsland4ID, false);
    //  if(rmRandFloat(0.0, 1.0)<0.70)
      rmAddAreaConstraint(bonusIsland4ID, bonusIslandConstraint);
      rmAddAreaToClass(bonusIsland4ID, classIsland);
      rmAddAreaToClass(bonusIsland4ID, classBonusIsland);
    //  rmAddAreaConstraint(bonusIsland4ID, bayConstraint);
	 // rmAddAreaConstraint(bonusIsland4ID, playerEdgeConstraint);
      rmSetAreaCoherence(bonusIsland4ID, 0.25);
      rmSetAreaSmoothDistance(bonusIsland4ID, 12);
	  rmSetAreaElevationType(bonusIsland4ID, cElevTurbulence);
		rmSetAreaElevationVariation(bonusIsland4ID, 2.0);
		rmSetAreaBaseHeight(bonusIsland4ID, 4.0);
		rmSetAreaElevationMinFrequency(bonusIsland4ID, 0.09);
		rmSetAreaElevationOctaves(bonusIsland4ID, 3);
		rmSetAreaElevationPersistence(bonusIsland4ID, 0.2);     

		int bonusIsland5ID=rmCreateArea("bonus island 5");
      rmSetAreaSize(bonusIsland5ID, 0.04, 0.04);
	  rmSetAreaLocation(bonusIsland5ID, 0.65, 0.25);
      rmSetAreaMix(bonusIsland5ID, "amazon_grass");
      rmSetAreaWarnFailure(bonusIsland5ID, false);
    //  if(rmRandFloat(0.0, 1.0)<0.70)
      rmAddAreaConstraint(bonusIsland5ID, bonusIslandConstraint);
      rmAddAreaToClass(bonusIsland5ID, classIsland);
      rmAddAreaToClass(bonusIsland5ID, classBonusIsland);
     // rmAddAreaConstraint(bonusIsland5ID, bayConstraint);
	 // rmAddAreaConstraint(bonusIsland5ID, playerEdgeConstraint);
      rmSetAreaCoherence(bonusIsland5ID, 0.25);
      rmSetAreaSmoothDistance(bonusIsland5ID, 12);
	  rmSetAreaElevationType(bonusIsland5ID, cElevTurbulence);
		rmSetAreaElevationVariation(bonusIsland5ID, 2.0);
		rmSetAreaBaseHeight(bonusIsland5ID, 4.0);
		rmSetAreaElevationMinFrequency(bonusIsland5ID, 0.09);
		rmSetAreaElevationOctaves(bonusIsland5ID, 3);
		rmSetAreaElevationPersistence(bonusIsland5ID, 0.2);     

		int bonusIsland6ID=rmCreateArea("bonus island 6");
      rmSetAreaSize(bonusIsland6ID, 0.04, 0.04);
	  rmSetAreaLocation(bonusIsland6ID, 0.65, 0.70);
      rmSetAreaMix(bonusIsland6ID, "amazon_grass");
      rmSetAreaWarnFailure(bonusIsland6ID, false);
    //  if(rmRandFloat(0.0, 1.0)<0.70)
      rmAddAreaConstraint(bonusIsland6ID, bonusIslandConstraint);
      rmAddAreaToClass(bonusIsland6ID, classIsland);
      rmAddAreaToClass(bonusIsland6ID, classBonusIsland);
      //rmAddAreaConstraint(bonusIsland6ID, bayConstraint);
	  //rmAddAreaConstraint(bonusIsland6ID, playerEdgeConstraint);
      rmSetAreaCoherence(bonusIsland6ID, 0.25);
      rmSetAreaSmoothDistance(bonusIsland6ID, 12);
	  rmSetAreaElevationType(bonusIsland6ID, cElevTurbulence);
		rmSetAreaElevationVariation(bonusIsland6ID, 2.0);
		rmSetAreaBaseHeight(bonusIsland6ID, 4.0);
		rmSetAreaElevationMinFrequency(bonusIsland6ID, 0.09);
		rmSetAreaElevationOctaves(bonusIsland6ID, 3);
		rmSetAreaElevationPersistence(bonusIsland6ID, 0.2);     
  
   rmBuildAllAreas();

int smallPondID=rmCreateArea("small pond");
		rmSetAreaSize(smallPondID, 0.008, 0.008);
		rmSetAreaWaterType(smallPondID, "great plains pond");
		rmSetAreaBaseHeight(smallPondID, 4);
		rmSetAreaMinBlobs(smallPondID, 4);
		rmSetAreaMaxBlobs(smallPondID, 6);
		rmSetAreaMinBlobDistance(smallPondID, 5.0);
		rmSetAreaMaxBlobDistance(smallPondID, 30.0);
		rmSetAreaCoherence(smallPondID, 0.3);
		rmSetAreaSmoothDistance(smallPondID, 5);
		rmSetAreaLocation(smallPondID, 0.5, 0.5); 
		rmBuildArea(smallPondID);


// text
rmSetStatusText("",0.30);

 //  rmBuildConnection(shallowsID);


	// Set up player starting locations. These are just used to place fluyts away from each other.

//   rmSetPlacementSection(0.9, 0.3);
//   rmSetPlayerPlacementArea(0, 0, 0.35, 0.35);
//   rmSetTeamSpacingModifier(0.50);
   rmPlacePlayersCircular(0.48, 0.48, 0);


    // Set up player areas.
   float playerFraction=rmAreaTilesToFraction(1000);
   for(i=1; <cNumberPlayers)
   {
      // Create the area.
      int id=rmCreateArea("Player"+i);
      // Assign to the player.
      rmSetPlayerArea(i, id);
      // Set the size.
//	  rmSetAreaMix(id, "amazon_grass");
//	  rmSetAreaBaseHeight(id, 4);
      rmSetAreaSize(id, playerFraction, playerFraction);
      rmAddAreaToClass(id, classPlayer);
      rmSetAreaMinBlobs(id, 1);
      rmSetAreaMaxBlobs(id, 1);
      rmAddAreaConstraint(id, playerConstraint); 
      rmAddAreaConstraint(id, playerEdgeConstraint); 
      rmSetAreaLocPlayer(id, i);
  //    rmSetAreaTerrainType(id, "amazon_grass");
   //   rmSetAreaBaseHeight(id, 10.0);
      rmSetAreaWarnFailure(id, false);
   }

   // Build the areas.
   rmBuildAllAreas();


   // Text
   rmSetStatusText("",0.60);

   int colonyShipID=rmCreateObjectDef("colony ship");
   rmAddObjectDefItem(colonyShipID, "fluyt", 1, 0.0);
   rmSetObjectDefGarrisonStartingUnits(colonyShipID, true);
   rmSetObjectDefMinDistance(colonyShipID, 0.0);
   rmSetObjectDefMaxDistance(colonyShipID, 5.0);

  // Set up for finding closest land points.
   rmAddClosestPointConstraint(avoidWater8);
	rmAddClosestPointConstraint(playerEdgeConstraint);
	rmAddClosestPointConstraint(flagConstraint);
	rmAddClosestPointConstraint(nearWater10);
   
   for(i=1; <cNumberPlayers)
   {
      // Place boat.
      int count = rmPlaceObjectDefAtLoc(colonyShipID, i, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
      if(count<1)
      {
         rmEchoError("Failed to place player "+i);
         continue;
      }

      // Get where it placed.
      vector colonyShipLocation=rmGetUnitPosition(rmGetUnitPlacedOfPlayer(colonyShipID, i));
      
      // Find closest point.
      vector closestPoint = rmFindClosestPointVector(colonyShipLocation, rmXFractionToMeters(0.25));
      rmEchoInfo("0.25 Fraction to Meters = "+rmXFractionToMeters(0.25));

      // Set HCGP.
      rmSetHomeCityGatherPoint(i, closestPoint);
   }
   


   // ***************************** side islands *****************************
for(i=0; <rmRandInt(28,30))
   {
      int smallIslandID=rmCreateArea("small island"+i);
      rmSetAreaSize(smallIslandID, 8.03, 1.04);
      rmSetAreaMix(smallIslandID, "amazon_grass");
      rmSetAreaWarnFailure(smallIslandID, false);
    //  if(rmRandFloat(0.0, 1.0)<0.70)
         rmAddAreaConstraint(smallIslandID, longBonusIslandConstraint);
	//	 rmAddAreaConstraint(smallIslandID, longSideIslandConstraint);
      rmAddAreaToClass(smallIslandID, classIsland);
      rmAddAreaToClass(smallIslandID, classBonusIsland);
	  rmAddAreaToClass(smallIslandID, classSideIsland);
      rmAddAreaConstraint(smallIslandID, bayConstraint);
	  rmAddAreaConstraint(smallIslandID, longPlayerConstraint);
	  rmAddAreaConstraint(smallIslandID, avoidBoats);
      rmSetAreaCoherence(smallIslandID, 0.25);
      rmSetAreaSmoothDistance(smallIslandID, 12);
	   rmSetAreaElevationType(smallIslandID, cElevTurbulence);
		rmSetAreaElevationVariation(smallIslandID, 2.0);
		rmSetAreaBaseHeight(smallIslandID, 4.0);
		rmSetAreaElevationMinFrequency(smallIslandID, 0.09);
		rmSetAreaObeyWorldCircleConstraint(smallIslandID, false);
		rmSetAreaElevationOctaves(smallIslandID, 3);
		rmSetAreaElevationPersistence(smallIslandID, 0.2);      
      }   
rmBuildAllAreas();


// text
rmSetStatusText("",0.70);
	


	int cottonType = -1;
	int cottonID = -1;
	for(i=0; <(2+cNumberNonGaiaPlayers))
   {
		cottonType = rmRandInt(1,4);
      cottonID = rmCreateGrouping("cotton "+i, "resource cotton "+cottonType);
      rmSetGroupingMinDistance(cottonID, 0.0);
      rmSetGroupingMaxDistance(cottonID, rmXFractionToMeters(0.5));
		rmAddGroupingConstraint(cottonID, avoidCoin);
      rmAddGroupingConstraint(cottonID, shortAvoidImpassableLand);
	   rmAddGroupingConstraint(cottonID, avoidCotton);

		rmPlaceGroupingAtLoc(cottonID, 0, 0.5, 0.5);
   }

	int silverType = rmRandInt(1,10);
	int silverID = -1;
	int silver2ID = -1;
	int silverCount = (cNumberNonGaiaPlayers*3);
	int bonusSilverCount = (cNumberNonGaiaPlayers);	
	rmEchoInfo("silver count = "+silverCount);
	rmEchoInfo("bonus silver count = "+bonusSilverCount);

	for(i=0; < silverCount)
	{
		silverType = rmRandInt(1,10);
      silverID = rmCreateGrouping("silver "+i, "resource silver ore "+silverType);
      rmSetGroupingMinDistance(silverID, 0.0);
      rmSetGroupingMaxDistance(silverID, rmXFractionToMeters(0.5));
		rmAddGroupingConstraint(silverID, farAvoidCoin);
		rmAddGroupingConstraint(silverID, avoidAll);
      rmAddGroupingConstraint(silverID, avoidImpassableLand);
		rmPlaceGroupingAtLoc(silverID, 0, 0.5, 0.5);
   }

	for(i=0; < bonusSilverCount)
	{
		silverType = rmRandInt(1,10);
      silver2ID = rmCreateGrouping("bonus silver "+i, "resource silver ore "+silverType);
      rmSetGroupingMinDistance(silver2ID, 0.0);
      rmSetGroupingMaxDistance(silver2ID, rmXFractionToMeters(0.5));
		rmAddGroupingConstraint(silver2ID, avoidCoin);
		rmAddGroupingConstraint(silver2ID, avoidAll);
      rmAddGroupingConstraint(silver2ID, avoidImpassableLand);
		rmPlaceGroupingAtLoc(silver2ID, 0, 0.5, 0.5);
   }

	// text
rmSetStatusText("",0.90);

	int nuggetID= rmCreateObjectDef("nugget"); 
	rmAddObjectDefItem(nuggetID, "Nugget", 6.3, 610);
	rmSetObjectDefMinDistance(nuggetID, 0.1);
	rmSetObjectDefMaxDistance(nuggetID, rmXFractionToMeters(3.2));
	rmAddObjectDefConstraint(nuggetID, avoidImpassableLand);
	rmAddObjectDefConstraint(nuggetID, avoidNugget);
	rmAddObjectDefConstraint(nuggetID, avoidAll);
	rmPlaceObjectDefAtLoc(nuggetID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*rmRandInt(9,10));

	int bisonID=rmCreateObjectDef("bison herd");
   rmAddObjectDefItem(bisonID, "bison", rmRandInt(14,15), 13.0);
   rmSetObjectDefMinDistance(bisonID, 0.0);
   rmSetObjectDefMaxDistance(bisonID, rmXFractionToMeters(0.5));
   rmAddObjectDefConstraint(bisonID, avoidbison);
	rmAddObjectDefConstraint(bisonID, avoidAll);
   rmAddObjectDefConstraint(bisonID, shortAvoidImpassableLand);
    rmAddObjectDefConstraint(bisonID, longSideIslandConstraint);
   rmSetObjectDefCreateHerd(bisonID, true);
	rmPlaceObjectDefAtLoc(bisonID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*2);
	
	int rheaID=rmCreateObjectDef("rhea flock");
   rmAddObjectDefItem(rheaID, "rhea", rmRandInt(15,18), 12.5);
   rmSetObjectDefMinDistance(rheaID, 0.0);
   rmSetObjectDefMaxDistance(rheaID, rmXFractionToMeters(0.5));
   rmAddObjectDefConstraint(rheaID, avoidbison);
   rmAddObjectDefConstraint(rheaID, avoidrhea);
	rmAddObjectDefConstraint(rheaID, avoidAll);
   rmAddObjectDefConstraint(rheaID, shortAvoidImpassableLand);
       rmAddObjectDefConstraint(rheaID, longSideIslandConstraint);
   rmSetObjectDefCreateHerd(rheaID, true);
	rmPlaceObjectDefAtLoc(rheaID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*4);

   // Define and place Forests
   int forestTreeID = 0;
   int numTries=19*cNumberNonGaiaPlayers;
   int failCount=0;
   for (i=0; <numTries)
      {   
         int forest=rmCreateArea("forest "+i);
         rmSetAreaWarnFailure(forest, false);
         rmSetAreaSize(forest, rmAreaTilesToFraction(300), rmAreaTilesToFraction(500));
         rmSetAreaForestType(forest, "caribbean palm forest");
         rmSetAreaForestDensity(forest, 60.0);
         rmSetAreaForestClumpiness(forest, 0.0);
         rmSetAreaForestUnderbrush(forest, 0.7);
         rmSetAreaMinBlobs(forest, 1);
         rmSetAreaMaxBlobs(forest, 5);
         rmSetAreaMinBlobDistance(forest, 16.0);
         rmSetAreaMaxBlobDistance(forest, 40.0);
         rmSetAreaCoherence(forest, 0.4);
         rmSetAreaSmoothDistance(forest, 10);
         rmAddAreaToClass(forest, rmClassID("classForest")); 
         rmAddAreaConstraint(forest, forestConstraint);
         rmAddAreaConstraint(forest, avoidAll);
         rmAddAreaConstraint(forest, shortAvoidImpassableLand); 
         if(rmBuildArea(forest)==false)
         {
            // Stop trying once we fail 3 times in a row.
            failCount++;
            if(failCount==5)
               break;
         }
         else
            failCount=0; 
      } 

   // wood resources
   /*
	int randomTreeID=rmCreateObjectDef("random tree");
   rmAddObjectDefItem(randomTreeID, "treeCaribbean", 5, 0.2);
   rmSetObjectDefMinDistance(randomTreeID, 0.0);
   rmSetObjectDefMaxDistance(randomTreeID, rmXFractionToMeters(0.5));
   rmAddObjectDefConstraint(randomTreeID, avoidAll);
   rmAddObjectDefConstraint(randomTreeID, shortAvoidImpassableLand);

   rmPlaceObjectDefAtLoc(randomTreeID, 0, 0.5, 0.5, 20*cNumberNonGaiaPlayers);
*/
   int treeVsLand = rmCreateTerrainDistanceConstraint("tree v. land", "land", true, 2.0);
   int nearShore=rmCreateTerrainMaxDistanceConstraint("tree v. water", "land", true, 14.0);

   int randomWaterTreeID=rmCreateObjectDef("random tree in water");
   rmAddObjectDefItem(randomWaterTreeID, "treeamazon", 1, 0.0);
   rmSetObjectDefMinDistance(randomWaterTreeID, 0.0);
   rmSetObjectDefMaxDistance(randomWaterTreeID, rmXFractionToMeters(0.5));
   rmAddObjectDefConstraint(randomWaterTreeID, nearShore);
   rmAddObjectDefConstraint(randomWaterTreeID, treeVsLand);

	  int fishID=rmCreateObjectDef("fish");
   rmAddObjectDefItem(fishID, "Fishsalmon", 9.0, 8.0);
   rmSetObjectDefMinDistance(fishID, 0.01);
   rmSetObjectDefMaxDistance(fishID, rmXFractionToMeters(0.7));
   rmAddObjectDefConstraint(fishID, fishVsFishID);
   rmAddObjectDefConstraint(fishID, fishLand);
   rmPlaceObjectDefAtLoc(fishID, 0, 0.5, 0.5, 16*cNumberNonGaiaPlayers);
   
      int whaleID=rmCreateObjectDef("whale");
   rmAddObjectDefItem(whaleID, "HumpbackWhale", 1, 0.0);
   rmSetObjectDefMinDistance(whaleID, 0.0);
   rmSetObjectDefMaxDistance(whaleID, rmXFractionToMeters(0.5));
   rmAddObjectDefConstraint(whaleID, whaleVsWhaleID);
   rmAddObjectDefConstraint(whaleID, whaleLand);
   rmPlaceObjectDefAtLoc(whaleID, 0, 0.5, 0.5, 4*cNumberNonGaiaPlayers);

   rmPlaceObjectDefAtLoc(randomWaterTreeID, 0, 0.5, 0.5, 50*cNumberNonGaiaPlayers);
// text
rmSetStatusText("",0.99);
}