/*================================================================================================================*/
// ********************************** THESE ARE THE INFORMATIONS OF THE MAP: ************************************ //
/*================================================================================================================*/
// FROM PLYMOUTH BY ENSEMBLE:
// NOVEMBER 2006:
// RMS FOR AGE OF EMPIRE 3:
// CREATED BY DANY:
// NOVEMBER 2006:
/*================================================================================================================*/
// ********************************** MAIN ENTRY POINT FOR RANDOM MAP SCRIPT: *********************************** //
/*================================================================================================================*/
include "mercenaries.xs";
void main(void)
{
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERAYION PROGRESS BAR:
   rmSetStatusText("",0.01);
/*================================================================================================================*/
// ********************************* CHOOSES WHICH NATIVES APPEAR ON THE MAP: *********************************** //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/
        int subCiv0=-1;
        int subCiv1=-1;
        int subCiv2=-1;
	    int subCiv3=-1;
/*----------------------------------------------------------------------------------------------------------------*/
	    // ALL IROQUOIS ALL THE TIME:
        if (rmAllocateSubCivs(4) == true)
/*----------------------------------------------------------------------------------------------------------------*/		
   {
/*----------------------------------------------------------------------------------------------------------------*/   
		subCiv0=rmGetCivID("Iroquois");
        if (subCiv0 >= 0)
        rmSetSubCiv(0, "Iroquois");

		subCiv1=rmGetCivID("Iroquois");
        if (subCiv1 >= 0)
        rmSetSubCiv(1, "Iroquois");

		subCiv2=rmGetCivID("Iroquois");
        if (subCiv2 >= 0)
        rmSetSubCiv(2, "Iroquois");

		subCiv3=rmGetCivID("Iroquois");
        if (subCiv3 >= 0)
        rmSetSubCiv(3, "Iroquois");
/*----------------------------------------------------------------------------------------------------------------*/		
	}
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERAYION PROGRESS BAR:
   rmSetStatusText("",0.05);
/*================================================================================================================*/
// ******************************************* PICKS THE MAP SIZE: ********************************************** //
/*================================================================================================================*/
      // int playerTiles = 12500;
	     int playerTiles = 25000;
      
	  if (cNumberNonGaiaPlayers >4)
	      // playerTiles = 11500;
	         playerTiles = 15000;
       
      int size = 2.0*sqrt(cNumberNonGaiaPlayers*playerTiles);
      rmEchoInfo("Map size = "+size+"m x "+size+"m");
      rmSetMapSize(size, size);
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERAYION PROGRESS BAR:
   rmSetStatusText("",0.10);
/*================================================================================================================*/
// **************************************** DEFINE THE MAP PARAMETERS: ****************************************** //	  
/*================================================================================================================*/
      // PICKS DEFAULT TERRAIN AND WATER:
      // rmSetSeaType("new england coast");
	      rmSetSeaType("great lakes ice"); // FROM GREAT LAKES:
		    //rmSetSeaType("Yukon River"); // FROM YUKON:
		 
	     
	  // SOME MAP TURBULENCE:
	  // rmSetMapElevationParameters(cElevTurbulence, 0.4, 6, 0.7, 5.0);  // LIKE TEXAS FOR THE MOMENT:
	     rmSetMapElevationParameters(cElevTurbulence, 0.02, 3, 0.5, 8.0); // FROM ROCKIES:
	  // rmSetMapElevationHeightBlend(0.2);
	     

      // PICKS A DEFAULT WATER HEIGHT:
      // rmSetSeaLevel(4.0);
	     rmSetSeaLevel(4.5); // FROM ROCKIES:
	     
      // rmEnableLocalWater(false);
	     rmEnableLocalWater(false); // FROM GREAT LAKES:
      
	  // SET BASE TERRAIN MIX:
	  rmSetBaseTerrainMix("rockies_snow");
      
	  // INITIALIZATION OF THE MAP:
	  rmTerrainInitialize("water");
	  // rmTerrainInitialize("rockies\groundsnow1_roc", 12);	
	  
	  
	  // SET MAP TYPE:
	  rmSetMapType("rockies");
	  rmSetMapType("snow"); // FROM GREAT LAKES:
	  rmSetMapType("water"); // FROM GREAT LAKES:
	  // rmSetMapType("plymouth");
	  // rmSetMapType("water");
	  // rmSetMapType("grass");
	  
	  // SET WORLD CIRCLE CONSTRAINT:
	  rmSetWorldCircleConstraint(true);
	  
	  // SET WIND MAGNITUDE:
	  // rmSetWindMagnitude(2.0); // REMOVED BY ME:
	  
	  // SET GLOBAL SNOW:
	  rmSetGlobalSnow( 1.0 ); // FROM GREAT LAKES:
	  
	  // SET THE LIGHTING:
	     rmSetLightingSet("rockies"); // FROM ROCKIES:
	  // rmSetLightingSet("new england");
	     
	  
      // CHOOSES THE MERCS:
	  chooseMercs();
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERAYION PROGRESS BAR:
   rmSetStatusText("",0.15);
/*================================================================================================================*/
// ************************ DEFINE SOME CLASSES: THESE ARE USED LATER FOR CONSTRAINTS: ************************** //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/
      int classPlayer = rmDefineClass("player");
	  rmDefineClass("classCliff");
      rmDefineClass("classPatch");
	  rmDefineClass("classWall");
      int classbigContinent = rmDefineClass("big continent");
      rmDefineClass("corner");
      rmDefineClass("starting settlement");
      rmDefineClass("startingUnit");
      rmDefineClass("classForest");
      rmDefineClass("importantItem");
	  rmDefineClass("secrets");
	  rmDefineClass("socketClass");
	  rmDefineClass("nuggets");
	  rmDefineClass("natives");
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERAYION PROGRESS BAR:
   rmSetStatusText("",0.20);
/*================================================================================================================*/
// ***************************************** DEFINE THE CONSTRAINTS: ******************************************** //
// ************************* THESE ARE USED TO HAVE OBJECTS AND AREAS AVOID EACH OTHER: ************************* //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/
      // MAP EDGE CONSTRAINTS:
      int playerEdgeConstraint = rmCreateBoxConstraint("player edge of map", rmXTilesToFraction(6), rmZTilesToFraction(6), 1.0-rmXTilesToFraction(6), 1.0-rmZTilesToFraction(6), 0.01);
      int longPlayerConstraint = rmCreateClassDistanceConstraint("continent stays away from players", classPlayer, 12.0);

      // PLAYER CONSTRAINTS:
      int playerConstraint = rmCreateClassDistanceConstraint("player vs. player", classPlayer, 10.0);
      int smallMapPlayerConstraint = rmCreateClassDistanceConstraint("stay away from players a lot", classPlayer, 70.0);

      // DIRECTIONAL CONSTRAINTS:
	  int Northwestward = rmCreatePieConstraint("northwestMapConstraint", 0.5, 0.5, 0, rmZFractionToMeters(0.5), rmDegreesToRadians(270), rmDegreesToRadians(180));  // 225 135, 300, 45
      int Southeastward = rmCreatePieConstraint("southeastMapConstraint", 0.5, 0.5, 0, rmZFractionToMeters(0.5), rmDegreesToRadians(90), rmDegreesToRadians(270));

      // BONUS AREA CONSTRAINT:
      int bigContinentConstraint = rmCreateClassDistanceConstraint("avoid bonus island", classbigContinent, 25.0);

      // RESOURCE AVOIDANCE:
      // int forestConstraint = rmCreateClassDistanceConstraint("forest vs. forest", rmClassID("classForest"), 10.0);
	     int forestConstraint = rmCreateClassDistanceConstraint("forest vs. forest", rmClassID("classForest"), 25.0);
      
      int avoidDeer = rmCreateTypeDistanceConstraint("food avoids food", "deer", 45.0);
	  int avoidFastCoin = rmCreateTypeDistanceConstraint("fast coin avoids coin", "gold", 30.0);
      int avoidCoin = rmCreateTypeDistanceConstraint("coin avoids coin", "gold", 35);
      int avoidCoinSmall = rmCreateTypeDistanceConstraint("stuff avoids coin a little", "gold", 20);
      int avoidNugget = rmCreateTypeDistanceConstraint("nugget avoid nugget", "AbstractNugget", 35.0);
      int avoidPlayerNugget = rmCreateTypeDistanceConstraint("player nugget avoid nugget", "AbstractNugget", 20.0);
      int avoidNuggetSmall = rmCreateTypeDistanceConstraint("nugget avoid nugget small", "AbstractNugget", 10.0);
      int avoidNatives=rmCreateClassDistanceConstraint("stuff avoids natives", rmClassID("natives"), 10.0);
	  int avoidBighorn=rmCreateTypeDistanceConstraint("bighorn avoids food", "bighornsheep", 5.0);
	  int avoidCaribou=rmCreateTypeDistanceConstraint("caribou avoids caribou", "Caribou", 50.0);
   	  int avoidCash = rmCreateTypeDistanceConstraint("stuffs avoids cash", "minegold", 35);

      // AVOID IMPASSABLE LAND:
	  int avoidImpassableLand = rmCreateTerrainDistanceConstraint("avoid impassable land", "Land", false, 6.0);
	  int shortAvoidImpassableLand = rmCreateTerrainDistanceConstraint("short avoid impassable land", "Land", false, 2.0);
	  int avoidCliffs = rmCreateClassDistanceConstraint("cliff vs. cliff", rmClassID("classCliff"), 10.0);
	  int patchConstraint = rmCreateClassDistanceConstraint("patch vs. patch", rmClassID("classPatch"), 5.0);
	  int wallConstraint = rmCreateClassDistanceConstraint("wall vs. wall", rmClassID("classWall"), 40.0);
	  int avoidSheep = rmCreateTypeDistanceConstraint("sheep avoids sheep", "sheep", 40.0);

      // SPECIFY TRUE SO CONSTRAINT STAYS OUTSIDE OF CIRCLE (I.E. INSIDE CORNERS)
      int cornerConstraint0 = rmCreateCornerConstraint("in corner 0", 0, true);
      int cornerConstraint1 = rmCreateCornerConstraint("in corner 1", 1, true);
      int cornerConstraint2 = rmCreateCornerConstraint("in corner 2", 2, true);
      int cornerConstraint3 = rmCreateCornerConstraint("in corner 3", 3, true);

      // UNIT AVOIDANCE:
      int avoidStartingUnits = rmCreateClassDistanceConstraint("objects avoid starting units", rmClassID("startingUnit"), 20.0);
      int avoidStartingUnitsSmall = rmCreateClassDistanceConstraint("objects avoid starting units small", rmClassID("startingUnit"), 5.0);

      // SHIPS VS. SHIPS:
      int shipVsShip = rmCreateTypeDistanceConstraint("ships avoid ship", "ship", 5.0);

      // DECORATION AVOIDANCE:
      int avoidAll = rmCreateTypeDistanceConstraint("avoid all", "all", 6.0);

      // VP AVOIDANCE:
      int avoidTradeRoute = rmCreateTradeRouteDistanceConstraint("trade route", 10.0);
      int avoidImportantItem = rmCreateClassDistanceConstraint("secrets etc avoid each other", rmClassID("importantItem"), 30.0);
	  int avoidSocket = rmCreateClassDistanceConstraint("avoid sockets", rmClassID("socketClass"), 12.0);

      // CONSTRAINT TO AVOID WATER:
      int avoidWater4 = rmCreateTerrainDistanceConstraint("avoid water", "Land", false, 4.0);
      int avoidWater15 = rmCreateTerrainDistanceConstraint("avoid water 15", "Land", false, 15.0);
      int avoidWater20 = rmCreateTerrainDistanceConstraint("avoid water medium", "Land", false, 20.0);
      int avoidWater30 = rmCreateTerrainDistanceConstraint("avoid water mid-long", "Land", false, 30.0);
      int avoidWater40 = rmCreateTerrainDistanceConstraint("avoid water long", "Land", false, 40.0);

      // NEW EXTRA STUFF FOR WATER SPAWN POINT AVOIDANCE:
	  int flagLand = rmCreateTerrainDistanceConstraint("flag vs land", "land", true, 20.0);
	  int flagVsFlag = rmCreateTypeDistanceConstraint("flag avoid same", "HomeCityWaterSpawnFlag", 15);
	  int flagEdgeConstraint = rmCreatePieConstraint("flags stay near edge of map", 0.5, 0.5, rmGetMapXSize()-20, rmGetMapXSize()-10, 0, 0, 0);

	  // CIRCLE CONSTRAINT:
	  int circleConstraint = rmCreatePieConstraint("circle Constraint", 0.5, 0.5, 0, rmZFractionToMeters(0.47), rmDegreesToRadians(0), rmDegreesToRadians(360));

	  // WHALE VS LAND CONSTRAINT:
	  int whaleLand = rmCreateTerrainDistanceConstraint("whale v. land", "land", true, 20.0);
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERAYION PROGRESS BAR:
   rmSetStatusText("",0.25);
/*================================================================================================================*/
// ******************************************** DEFINE THE AREAS: *********************************************** //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/
/*================================================================================================================*/
// ******************* BUILD UP BIG CONTINENT - CALLED, UNORIGINALLY ENOUGH, "BIG CONTINENT": ******************* //
/*================================================================================================================*/
      int bigContinentID = rmCreateArea("big continent");
      rmSetAreaSize(bigContinentID, 0.52, 0.52);		// 0.65, 0.65
      rmSetAreaWarnFailure(bigContinentID, false);
      rmAddAreaConstraint(bigContinentID, longPlayerConstraint);
      rmAddAreaToClass(bigContinentID, classbigContinent);
      rmSetAreaSmoothDistance(bigContinentID, 25);
	  // rmSetAreaMix(bigContinentID, "newengland_grass");
	     // rmSetAreaMix(bigContinentID, "great_lakes_ice");
		    rmSetAreaMix(bigContinentID, "rockies_snow");
      rmSetAreaElevationType(bigContinentID, cElevTurbulence);
      rmSetAreaElevationVariation(bigContinentID, 2.0);
      rmSetAreaBaseHeight(bigContinentID, 6.0);
      rmSetAreaElevationMinFrequency(bigContinentID, 0.09);
      rmSetAreaElevationOctaves(bigContinentID, 3);
      rmSetAreaElevationPersistence(bigContinentID, 0.2);      
	  rmSetAreaCoherence(bigContinentID, 0.5);
	  // rmSetAreaLocation(bigContinentID, 0.5, 0.85);
	     rmSetAreaLocation(bigContinentID, 0.5, 0.15);
      rmSetAreaEdgeFilling(bigContinentID, 5);
	  rmSetAreaObeyWorldCircleConstraint(bigContinentID, false);
	  rmBuildArea(bigContinentID);
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERAYION PROGRESS BAR:
   rmSetStatusText("",0.30);
/*================================================================================================================*/
// ******************** BUILD UP SMALL CONTINENT SPURS CALLED "SMALL CONTINENT SPUR 1 & 2": ********************* //
/*================================================================================================================*/
      int smallContinent1ID = rmCreateArea("small continent spur 1");
      rmSetAreaSize(smallContinent1ID, 0.2, 0.2);
      rmSetAreaWarnFailure(smallContinent1ID, false);
      rmAddAreaConstraint(smallContinent1ID, longPlayerConstraint);
      rmAddAreaToClass(smallContinent1ID, classbigContinent);
      rmSetAreaSmoothDistance(smallContinent1ID, 25);
	  // rmSetAreaMix(smallContinent1ID, "newengland_grass");
	     // rmSetAreaMix(smallContinent1ID, "great_lakes_ice");
		    rmSetAreaMix(smallContinent1ID, "rockies_snow");
      rmSetAreaElevationType(smallContinent1ID, cElevTurbulence);
      rmSetAreaElevationVariation(smallContinent1ID, 2.0);
      rmSetAreaBaseHeight(smallContinent1ID, 6.0);
      rmSetAreaElevationMinFrequency(smallContinent1ID, 0.09);
      rmSetAreaElevationOctaves(smallContinent1ID, 3);
      rmSetAreaElevationPersistence(smallContinent1ID, 0.2);      
	  rmSetAreaCoherence(smallContinent1ID, 0.5);
	  // rmSetAreaLocation(smallContinent1ID, 0.8, 0.6);
	     rmSetAreaLocation(smallContinent1ID, 0.8, 0.4);
      rmSetAreaEdgeFilling(smallContinent1ID, 5);
      rmSetAreaObeyWorldCircleConstraint(smallContinent1ID, false);
	  rmBuildArea(smallContinent1ID);
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERAYION PROGRESS BAR:
   rmSetStatusText("",0.35);
/*================================================================================================================*/
// ******************** BUILD UP SMALL CONTINENT SPURS CALLED "SMALL CONTINENT SPUR 1 & 2": ********************* //
/*================================================================================================================*/
      int smallContinent2ID = rmCreateArea("small continent spur 2");
      rmSetAreaSize(smallContinent2ID, 0.2, 0.2);
      rmSetAreaWarnFailure(smallContinent2ID, false);
      rmAddAreaConstraint(smallContinent2ID, longPlayerConstraint);
      rmAddAreaToClass(smallContinent2ID, classbigContinent);
      rmSetAreaSmoothDistance(smallContinent2ID, 25);
	  // rmSetAreaMix(smallContinent2ID, "newengland_grass");
	     // rmSetAreaMix(smallContinent2ID, "great_lakes_ice");
		    rmSetAreaMix(smallContinent2ID, "rockies_snow");
	  rmSetAreaElevationType(smallContinent2ID, cElevTurbulence);
      rmSetAreaElevationVariation(smallContinent2ID, 2.0);
      rmSetAreaBaseHeight(smallContinent2ID, 6.0);
      rmSetAreaElevationMinFrequency(smallContinent2ID, 0.09);
      rmSetAreaElevationOctaves(smallContinent2ID, 3);
      rmSetAreaElevationPersistence(smallContinent2ID, 0.2);      
	  rmSetAreaCoherence(smallContinent2ID, 0.5);
	  // rmSetAreaLocation(smallContinent2ID, 0.2, 0.6);
	     rmSetAreaLocation(smallContinent2ID, 0.2, 0.4);
      rmSetAreaEdgeFilling(smallContinent2ID, 5);
      rmSetAreaObeyWorldCircleConstraint(smallContinent2ID, false);
	  rmBuildArea(smallContinent2ID);
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERAYION PROGRESS BAR:
   rmSetStatusText("",0.40);
/*================================================================================================================*/

   bool southSide = true;
   float spacing = (0.2 / (cNumberPlayers - 1));

	if (cNumberTeams == 2)
	{
		rmSetPlacementTeam(0);
		rmPlacePlayersLine(0.2, 0.5, 0.2, 0.8, 0.0, 0.2);

		rmSetPlacementTeam(1);
		rmPlacePlayersLine(0.8, 0.5, 0.8, 0.8, 0.0, 0.2);
	}
	else
	{
	   for (i = 0; < (cNumberPlayers - 1))
      {
         rmEchoInfo("i = "+i);
         float iFloat = i;
         if (southSide == true)
         {
            rmSetPlacementTeam(i);
            rmSetPlacementSection((0.075 + ((iFloat) * spacing)), 0.25);
	         rmSetTeamSpacingModifier(0.25);
	         rmPlacePlayersCircular(0.4, 0.4, 0);
         }
         else
         {
            rmSetPlacementTeam(i);
            rmSetPlacementSection((0.75 + ((iFloat) * spacing)), 0.95);
	         rmSetTeamSpacingModifier(0.25);
	         rmPlacePlayersCircular(0.4, 0.4, 0);
         }
         if (southSide == true)
         {
            southSide = false;
         }
         else
         {
            southSide = true;
         }
      }
	}
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERAYION PROGRESS BAR:
   rmSetStatusText("",0.45);
/*================================================================================================================*/
// ******************************************* SET UP PLAYER AREAS: ********************************************* //
/*================================================================================================================*/
   float playerFraction = rmAreaTilesToFraction(100);
/*----------------------------------------------------------------------------------------------------------------*/   
   for(i = 1; < cNumberPlayers)
/*----------------------------------------------------------------------------------------------------------------*/   
   {
/*----------------------------------------------------------------------------------------------------------------*/   
      // CREATE THE AREA:
      int id = rmCreateArea("Player"+i);
      
	  // ASSIGN TO THE PLAYER:
      rmSetPlayerArea(i, id);
      
	  // SET THE SIZE:
      rmSetAreaSize(id, playerFraction, playerFraction);
      
	  // ADD AREA TO CLASS:
	  rmAddAreaToClass(id, classPlayer);
      
	  // SET AREA MIN AND MAX BLOBS:
	  rmSetAreaMinBlobs(id, 1);
      rmSetAreaMaxBlobs(id, 1);
      
	  // SET AREA LOC PLAYER:
	  rmSetAreaLocPlayer(id, i);
	  
	  // SET AREA TERRAIN TYPE:
	  // NONE FOR NOW:
     
	  // SET AREA WARN FAILURE:
	  rmSetAreaWarnFailure(id, false);
/*----------------------------------------------------------------------------------------------------------------*/	  
   }
/*----------------------------------------------------------------------------------------------------------------*/   
      // BUILD THE AREAS:
      rmBuildAllAreas();
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERAYION PROGRESS BAR:
   rmSetStatusText("",0.46);
/*================================================================================================================*/
// PLACEMENT ORDER:
// ISLANDS -> NATIVES -> SECRETS -> CLIFFS -> NUGGETS:
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERAYION PROGRESS BAR:
   rmSetStatusText("",0.47);
/*================================================================================================================*/
// ************************** ISLES OF SHOALS - THESE ARE SET IN SPECIFICS LOCATIONS: *************************** //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/
      int bonusIslandID1 = rmCreateArea("isle of shoals 1");
      rmSetAreaSize(bonusIslandID1, rmAreaTilesToFraction(450), rmAreaTilesToFraction(450));
      // rmSetAreaTerrainType(bonusIslandID1, "new_england\ground1_ne");
	     rmSetAreaTerrainType(bonusIslandID1, "rockies\groundsnow1_roc");
      // rmSetAreaMix(bonusIslandID1, "newengland_grass");
	     rmSetAreaMix(bonusIslandID1, "rockies_snow");
      rmSetAreaBaseHeight(bonusIslandID1, 6.0);
      rmSetAreaSmoothDistance(bonusIslandID1, 5);
      rmSetAreaWarnFailure(bonusIslandID1, false);
	  rmSetAreaMinBlobs(bonusIslandID1, 4);
      rmSetAreaMaxBlobs(bonusIslandID1, 5);
      rmSetAreaMinBlobDistance(bonusIslandID1, 8.0);
	  rmSetAreaMaxBlobDistance(bonusIslandID1, 12.0);
      rmSetAreaCoherence(bonusIslandID1, 0.50);
      rmAddAreaConstraint(bonusIslandID1, bigContinentConstraint);
      rmAddAreaConstraint(bonusIslandID1, longPlayerConstraint);
      // rmSetAreaLocation(bonusIslandID1, 0.50, 0.15);
	     rmSetAreaLocation(bonusIslandID1, 0.50, 0.85);
      rmBuildArea(bonusIslandID1);
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERAYION PROGRESS BAR:
   rmSetStatusText("",0.50);
/*================================================================================================================*/
// *********************************** DEFINE AND PLACE THE NATIVE AMERICANS: *********************************** //
/*================================================================================================================*/   
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/
    	if (subCiv0 == rmGetCivID("iroquois"))
/*----------------------------------------------------------------------------------------------------------------*/		
	{  
		int iroquoisVillage1ID = -1;
		iroquoisVillage1ID = rmCreateGrouping("iroquois village 1", "native iroquois village 1");
		rmSetGroupingMinDistance(iroquoisVillage1ID, 0.0);
		//rmSetGroupingMaxDistance(iroquoisVillage1ID, rmXFractionToMeters(0.5));
		  rmSetGroupingMaxDistance(iroquoisVillage1ID, 0.0);
		rmAddGroupingConstraint(iroquoisVillage1ID, avoidImpassableLand);
		rmAddGroupingToClass(iroquoisVillage1ID, rmClassID("importantItem"));
		rmAddGroupingConstraint(iroquoisVillage1ID, avoidTradeRoute);
		//rmAddGroupingConstraint(iroquoisVillage1ID, avoidCliffs);
		//rmAddGroupingConstraint(iroquoisVillage1ID, North1ward);
		//rmPlaceGroupingAtLoc(iroquoisVillage1ID, 0, 0.5, 0.5);
		  rmPlaceGroupingAtLoc(iroquoisVillage1ID, 0, 0.50, 0.20);
	} 
/*----------------------------------------------------------------------------------------------------------------*/
		if (subCiv1 == rmGetCivID("iroquois"))
/*----------------------------------------------------------------------------------------------------------------*/		
	{  
		int iroquoisVillage2ID = -1;
		iroquoisVillage2ID = rmCreateGrouping("iroquois village 2", "native iroquois village 1");
		rmSetGroupingMinDistance(iroquoisVillage2ID, 0.0);
		//rmSetGroupingMaxDistance(iroquoisVillage2ID, rmXFractionToMeters(0.5));
		  rmSetGroupingMaxDistance(iroquoisVillage2ID, 0.0);
		rmAddGroupingConstraint(iroquoisVillage2ID, avoidImpassableLand);
		rmAddGroupingToClass(iroquoisVillage2ID, rmClassID("importantItem"));
		rmAddGroupingConstraint(iroquoisVillage2ID, avoidTradeRoute);
		//rmAddGroupingConstraint(iroquoisVillage2ID, avoidCliffs);
		//rmAddGroupingConstraint(iroquoisVillage2ID, South1ward);
		//rmPlaceGroupingAtLoc(iroquoisVillage2ID, 0, 0.5, 0.5);
		rmPlaceGroupingAtLoc(iroquoisVillage2ID, 0, 0.65, 0.30);
	} 
/*----------------------------------------------------------------------------------------------------------------*/
		if (subCiv2 == rmGetCivID("iroquois"))
/*----------------------------------------------------------------------------------------------------------------*/		
	{  
		int iroquoisVillage3ID = -1;
		iroquoisVillage3ID = rmCreateGrouping("iroquois village 3", "native iroquois village 1");
		rmSetGroupingMinDistance(iroquoisVillage3ID, 0.0);
		//rmSetGroupingMaxDistance(iroquoisVillage3ID, rmXFractionToMeters(0.5));
		rmSetGroupingMaxDistance(iroquoisVillage3ID, 0.0);
		rmAddGroupingConstraint(iroquoisVillage3ID, avoidImpassableLand);
		rmAddGroupingToClass(iroquoisVillage3ID, rmClassID("importantItem"));
		rmAddGroupingConstraint(iroquoisVillage3ID, avoidTradeRoute);
		//rmAddGroupingConstraint(iroquoisVillage3ID, East1ward);
		//rmPlaceGroupingAtLoc(iroquoisVillage3ID, 0, 0.5, 0.5);
		rmPlaceGroupingAtLoc(iroquoisVillage3ID, 0, 0.675, 0.575);
	} 
/*----------------------------------------------------------------------------------------------------------------*/
		if (subCiv3 == rmGetCivID("iroquois"))
/*----------------------------------------------------------------------------------------------------------------*/		
	{  
		int iroquoisVillage4ID = -1;
		iroquoisVillage4ID = rmCreateGrouping("iroquois village 4", "native iroquois village 1");
		rmSetGroupingMinDistance(iroquoisVillage4ID, 0.0);
		//rmSetGroupingMaxDistance(iroquoisVillage4ID, rmXFractionToMeters(0.5));
		rmSetGroupingMaxDistance(iroquoisVillage4ID, 0.0);
		rmAddGroupingConstraint(iroquoisVillage4ID, avoidImpassableLand);
		rmAddGroupingToClass(iroquoisVillage4ID, rmClassID("importantItem"));
		rmAddGroupingConstraint(iroquoisVillage4ID, avoidTradeRoute);
		//rmAddGroupingConstraint(iroquoisVillage4ID, West1ward);
		//rmPlaceGroupingAtLoc(iroquoisVillage4ID, 0, 0.5, 0.5);
		rmPlaceGroupingAtLoc(iroquoisVillage4ID, 0, 0.20, 0.35);
	}
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERAYION PROGRESS BAR:
   rmSetStatusText("",0.55);
/*================================================================================================================*/
// **************************************** STARTING UNIT PLACEMENT: ******************************************** //
/*================================================================================================================*/
	  int startingUnits = rmCreateStartingUnitsObjectDef(5.0);
	  rmSetObjectDefMinDistance(startingUnits, 5.0);
	  rmSetObjectDefMaxDistance(startingUnits, 10.0);
	  rmAddObjectDefToClass(startingUnits, rmClassID("startingUnit"));
	  rmAddObjectDefConstraint(startingUnits, avoidAll);

	  int startingTCID =  rmCreateObjectDef("startingTC");
	  if ( rmGetNomadStart())
	  {
		  rmAddObjectDefItem(startingTCID, "CoveredWagon", 1, 0.0);
	  }
	  else
	  {
		  // rmAddObjectDefItem(startingTCID, "CoveredWagon", 1, 0.0);
		     rmAddObjectDefItem(startingTCID, "TownCenter", 1, 0.0);
	  }
	  rmAddObjectDefToClass(startingTCID, rmClassID("startingUnit"));
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERAYION PROGRESS BAR:
   rmSetStatusText("",0.60);
/*================================================================================================================*/
/*================================================================================================================*/
// ************************************* DEFINE THE STARTING RESOURCES: ***************************************** //
/*================================================================================================================*/
	// DEFINE THE STARTING SILVER MINES:
	int silverType = -1;
	int playerGoldID = -1;

	// DEFINE THE STARTING TREES:
	int StartAreaTreeID = rmCreateObjectDef("starting trees");
	rmAddObjectDefItem(StartAreaTreeID, "TreeRockiesSnow", 1, 0.0);
	rmSetObjectDefMinDistance(StartAreaTreeID, 10.0);
	rmSetObjectDefMaxDistance(StartAreaTreeID, 15.0);
	rmAddObjectDefConstraint(StartAreaTreeID, avoidStartingUnitsSmall);

	// DEFINE THE STARTING BERRYBUSH:
	int StartBerryBushID = rmCreateObjectDef("starting BerryBush");
	rmAddObjectDefItem(StartBerryBushID, "BerryBush", 3, 5.0);
	rmSetObjectDefMinDistance(StartBerryBushID, 10.0);
	rmSetObjectDefMaxDistance(StartBerryBushID, 15.0);
	rmAddObjectDefConstraint(StartBerryBushID, avoidStartingUnitsSmall);

	// DEFINE THE PLAYER NUGGET:
	int playerNuggetID = rmCreateObjectDef("player nugget");
	rmAddObjectDefItem(playerNuggetID, "nugget", 1, 0.0);
	rmAddObjectDefToClass(playerNuggetID, rmClassID("nuggets"));
    rmSetObjectDefMinDistance(playerNuggetID, 30.0);
    rmSetObjectDefMaxDistance(playerNuggetID, 35.0);
	rmAddObjectDefConstraint(playerNuggetID, avoidStartingUnitsSmall);
	rmAddObjectDefConstraint(playerNuggetID, avoidPlayerNugget);
	rmAddObjectDefConstraint(playerNuggetID, circleConstraint);

	// DEFINE THE WATER FLAG:
	int waterFlagID = -1;
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERAYION PROGRESS BAR:
   rmSetStatusText("",0.65);
/*================================================================================================================*/   
// ****************************** PLACE THE STARTING TCID AND THE STARTING UNITS: ******************************* //
/*================================================================================================================*/
    	for(i = 1; <cNumberPlayers)
/*----------------------------------------------------------------------------------------------------------------*/		
	{
/*----------------------------------------------------------------------------------------------------------------*/	
		rmClearClosestPointConstraints();
/*----------------------------------------------------------------------------------------------------------------*/		
		// PLACE THE STARTING TCID AND STARTING UNITS:
		rmPlaceObjectDefAtLoc(startingTCID, i, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(startingUnits, i, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
/*================================================================================================================*/
// ************************************** PLACE THE STARTING RESOURCES: ***************************************** //
/*================================================================================================================*/
		// EVERYONE GETS ONE ORE GROUPING CLOSE BY:
		silverType = rmRandInt(1,10);
		playerGoldID = rmCreateObjectDef("player silver closer "+i);
		rmAddObjectDefItem(playerGoldID, "mine", 1, 0.0);
		rmAddObjectDefConstraint(playerGoldID, avoidTradeRoute);
		rmAddObjectDefConstraint(playerGoldID, avoidStartingUnitsSmall);
		rmSetObjectDefMinDistance(playerGoldID, 15.0);
		rmSetObjectDefMaxDistance(playerGoldID, 20.0);
		rmPlaceObjectDefAtLoc(playerGoldID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));

        // PLACING THE STARTING BERRYBUSH:
		rmPlaceObjectDefAtLoc(StartBerryBushID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		
		// PLACING THE STARTING TREES:
		rmPlaceObjectDefAtLoc(StartAreaTreeID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(StartAreaTreeID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(StartAreaTreeID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(StartAreaTreeID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(StartAreaTreeID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));

		// PLACING THE PLAYER NUGGETS:
		rmSetNuggetDifficulty(1, 1);
		rmPlaceObjectDefAtLoc(playerNuggetID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(playerNuggetID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));

		// PLACING THE WATER FLAG:
		waterFlagID = rmCreateObjectDef("HC water flag "+i);
		rmAddObjectDefItem(waterFlagID, "HomeCityWaterSpawnFlag", 1, 0.0);
		rmAddClosestPointConstraint(flagEdgeConstraint);
		rmAddClosestPointConstraint(flagVsFlag);
		rmAddClosestPointConstraint(flagLand);
		vector TCLocation = rmGetUnitPosition(rmGetUnitPlacedOfPlayer(startingTCID, i));
        vector closestPoint = rmFindClosestPointVector(TCLocation, rmXFractionToMeters(1.0));
		rmPlaceObjectDefAtLoc(waterFlagID, i, rmXMetersToFraction(xsVectorGetX(closestPoint)), rmZMetersToFraction(xsVectorGetZ(closestPoint)));
		rmClearClosestPointConstraints();
/*================================================================================================================*/
/*      // Pilgrims
      int pilgrimGroupType = rmRandInt(1,2);
      int pilgrimGroup = 0;
      pilgrimGroup = rmCreateGrouping("Pilgrim Group "+i, "Plymouth_PilgrimGroup "+pilgrimGroupType);
      rmSetGroupingMinDistance(pilgrimGroup, 6.0);
      rmSetGroupingMaxDistance(pilgrimGroup, 8.0);
      rmAddGroupingToClass(pilgrimGroup, rmClassID("startingUnit"));
      rmAddGroupingConstraint(pilgrimGroup, avoidTradeRoute);
      rmAddGroupingConstraint(pilgrimGroup, avoidStartingUnitsSmall);
      rmPlaceGroupingAtLoc(pilgrimGroup, i, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));*/
}	  
/*----------------------------------------------------------------------------------------------------------------*/
	  int caribouID = rmCreateObjectDef("caribou herd");
	  int bonusChance2 = rmRandFloat(0, 1);
/*----------------------------------------------------------------------------------------------------------------*/  
	  if(bonusChance2<0.5)
      rmAddObjectDefItem(caribouID, "caribou", rmRandInt(6,8), 4.0);
      else
      rmAddObjectDefItem(caribouID, "caribou", rmRandInt(7,9), 6.0);
/*----------------------------------------------------------------------------------------------------------------*/	  
	  rmSetObjectDefMinDistance(caribouID, 0.0);
	  rmSetObjectDefMaxDistance(caribouID, rmXFractionToMeters(0.5));
	  rmAddObjectDefConstraint(caribouID, avoidCaribou);
	  rmAddObjectDefConstraint(caribouID, avoidAll);
	  rmAddObjectDefConstraint(caribouID, avoidCliffs);
	  rmAddObjectDefConstraint(caribouID, avoidSocket);
	  rmAddObjectDefConstraint(caribouID, avoidTradeRoute);
	  rmAddObjectDefConstraint(caribouID, avoidImpassableLand);
	  rmAddObjectDefConstraint(caribouID, avoidDeer);
	  rmAddObjectDefConstraint(caribouID, avoidStartingUnits);
	  rmSetObjectDefCreateHerd(caribouID, true);
	  rmPlaceObjectDefInArea(caribouID, 0, bigContinentID, cNumberNonGaiaPlayers*2);
/*----------------------------------------------------------------------------------------------------------------*/	  
	
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERAYION PROGRESS BAR:
   rmSetStatusText("",0.70);
/*================================================================================================================*/
// ******************** DEFINE AND PLACE A FEW SMALLISH CLIFFS ON THE NORTHWEST SIDE (INLAND) ******************* //
/*================================================================================================================*/ 	  
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/
	    int numTries = 2 * cNumberNonGaiaPlayers;
	    int failCount = 0;
	    for(i = 0; <numTries)
	{
		int cliffID = rmCreateArea("cliff "+i);
	    rmSetAreaSize(cliffID, rmAreaTilesToFraction(100), rmAreaTilesToFraction(100));
		rmSetAreaWarnFailure(cliffID, false);
		// rmSetAreaCliffType(cliffID, "New England");
		   rmSetAreaCliffType(cliffID, "rocky mountain2");
        
		// ATTEMPT TO KEEP CLIFFS AWAY FROM EACH OTHER:
		rmAddAreaToClass(cliffID, rmClassID("classCliff"));
		
		rmSetAreaCliffEdge(cliffID, 1, 1);
		rmSetAreaCliffPainting(cliffID, true, true, true, 1.5, true);
		rmSetAreaCliffHeight(cliffID, 4, 1.0, 1.0);
		rmSetAreaHeightBlend(cliffID, 1.0);
		// rmAddAreaTerrainLayer(cliffID, "new_england\ground4_ne", 0, 2);
		   rmAddAreaTerrainLayer(cliffID, "rockies\groundsnow6_roc", 0, 2);
        
		// AVOID OTHER CLIFFS, PLEASE:
		rmAddAreaConstraint(cliffID, avoidCliffs);
        
		rmAddAreaConstraint(cliffID, avoidCoinSmall);
		rmAddAreaConstraint(cliffID, avoidImportantItem);
        rmAddAreaConstraint(cliffID, avoidStartingUnits);
		rmAddAreaConstraint(cliffID, avoidTradeRoute);
		rmAddAreaConstraint(cliffID, avoidWater20);
        
		// CLIFF ARE ON THE NORTHWEST SIDE OF THE MAP:
		rmAddAreaConstraint(cliffID, Northwestward);
		
		rmSetAreaSmoothDistance(cliffID, 10);
		rmSetAreaCoherence(cliffID, 0.25);

		if(rmBuildArea(cliffID) == false)
		{
			// Stop trying once we fail 3 times in a row
			failCount++;
			if(failCount == 3)
				break;
		}
		else
			failCount = 0;
	}
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERAYION PROGRESS BAR:
   rmSetStatusText("",0.75);
/*================================================================================================================*/
// ************************************* DEFINE AND PLACE THE NUGGETS: ****************************************** //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/
      int nuggetID =  rmCreateObjectDef("nugget"); 
	  rmAddObjectDefItem(nuggetID, "Nugget", 1, 0.0);
	  rmSetObjectDefMinDistance(nuggetID, 0.0);
	  rmSetObjectDefMaxDistance(nuggetID, rmXFractionToMeters(0.5));
	  rmAddObjectDefConstraint(nuggetID, shortAvoidImpassableLand);
  	  rmAddObjectDefConstraint(nuggetID, avoidNugget);
	  rmAddObjectDefConstraint(nuggetID, avoidStartingUnits);
  	  rmAddObjectDefConstraint(nuggetID, avoidTradeRoute);
	  rmAddObjectDefConstraint(nuggetID, avoidSocket);
  	  rmAddObjectDefConstraint(nuggetID, avoidAll);
  	  rmAddObjectDefConstraint(nuggetID, avoidWater20);
	  rmAddObjectDefConstraint(nuggetID, circleConstraint);
	  rmSetNuggetDifficulty(1, 3);
	  rmPlaceObjectDefInArea(nuggetID, 0, bigContinentID, cNumberNonGaiaPlayers*5);
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.76);
/*================================================================================================================*/   
// ******************************* DEFINE AND PLACE THE TREES ON BONUS ISLAND: ********************************** //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/
      int islandNativeID =  rmCreateObjectDef("island natives"); 
	  rmAddObjectDefConstraint(islandNativeID, avoidWater4);
	  // rmAddObjectDefItem(islandNativeID, "TreeNewEngland", 1, 0.0);
	     rmAddObjectDefItem(islandNativeID, "TreeRockiesSnow", 1, 0.0);
	  rmPlaceObjectDefInArea(islandNativeID, 0, bonusIslandID1, 7);
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.77);
/*================================================================================================================*/   
// ****************************** PLACEMENT OF PUMKIN PATCH ON THE BONUS ISLANDS: ******************************* //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/
/*      int pumpkinPatchGroupType = rmRandInt(1,6);
	  int islandPumpkinPatchID = rmCreateGrouping("Pumpkin patch", "Plymouth_PumpkinPatch "+pumpkinPatchGroupType);
	  rmAddGroupingConstraint(islandPumpkinPatchID, avoidWater4);
	  rmPlaceGroupingInArea(islandPumpkinPatchID, 0, bonusIslandID1, 1);*/
	  
	  int bighorn1ID=rmCreateObjectDef("bighorn herd 1");
	  rmAddObjectDefItem(bighorn1ID, "BighornSheep", rmRandInt(3,5), 4.0);
	  rmAddObjectDefConstraint(bighorn1ID, avoidWater4);
	  rmAddObjectDefConstraint(bighorn1ID, avoidBighorn);
	  rmAddObjectDefConstraint(bighorn1ID, avoidCash);
	  rmSetObjectDefCreateHerd(bighorn1ID, true);
	   // rmPlaceObjectDefAtLoc(bighorn1ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers);
	      rmPlaceObjectDefInArea(bighorn1ID, 0, bonusIslandID1, 2);
		  
	
		int GoldMineID = rmCreateObjectDef("silver south ");
		rmAddObjectDefItem(GoldMineID, "minegold", 1, 0.0);
		rmAddObjectDefConstraint(GoldMineID, avoidWater4);
		rmAddObjectDefConstraint(GoldMineID, avoidBighorn);
		rmAddObjectDefConstraint(GoldMineID, avoidCash);
		rmPlaceObjectDefInArea(GoldMineID, 0, bonusIslandID1, 1);	  
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.78);
/*================================================================================================================*/   
// ************************************* DEFINE AND PLACE THE FISHES: ******************************************* //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/
      int fishVsFishID = rmCreateTypeDistanceConstraint("fish v fish", "fish", 20.0);
      int fishLand = rmCreateTerrainDistanceConstraint("fish land", "land", true, 6.0);
      int whaleVsWhaleID = rmCreateTypeDistanceConstraint("whale v whale", "minkeWhale", 25.0);
/*----------------------------------------------------------------------------------------------------------------*/
      int fishID = rmCreateObjectDef("fish");
      rmAddObjectDefItem(fishID, "FishCod", 2, 5.0);
      rmSetObjectDefMinDistance(fishID, 0.0);
      rmSetObjectDefMaxDistance(fishID, rmXFractionToMeters(0.5));
      rmAddObjectDefConstraint(fishID, fishVsFishID);
      rmAddObjectDefConstraint(fishID, fishLand);
      // rmPlaceObjectDefAtLoc(fishID, 0, 0.5, 0.0, cNumberNonGaiaPlayers*5);
	     rmPlaceObjectDefAtLoc(fishID, 0, 0.5, 1.0, cNumberNonGaiaPlayers*15);
/*----------------------------------------------------------------------------------------------------------------*/
	  // FAST COIN -- WHALES:
	  int whaleID = rmCreateObjectDef("whale");
      rmAddObjectDefItem(whaleID, "minkeWhale", 1, 9.0);
      rmSetObjectDefMinDistance(whaleID, 0.0);
      rmSetObjectDefMaxDistance(whaleID, rmXFractionToMeters(0.5));
      rmAddObjectDefConstraint(whaleID, whaleVsWhaleID);
      rmAddObjectDefConstraint(whaleID, whaleLand);
      rmPlaceObjectDefAtLoc(whaleID, 0, 0.5, 0.5, 3*cNumberNonGaiaPlayers);
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.79);
/*================================================================================================================*/   
// ******************************* PLACE RESOURCES THAT WE WANT FORESTS TO AVOID ******************************** //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/
	    // FAST COIN:
	    int silverID = -1;
	    int silverCount = cNumberNonGaiaPlayers*3;	// 3 per player, plus starting one.
	    rmEchoInfo("silver count = "+silverCount);

	    for(i = 0; < silverCount)
	{
		silverType = rmRandInt(1,10);
		silverID = rmCreateObjectDef("silver "+i);
		rmAddObjectDefItem(silverID, "mine", 1, 0.0);
		rmSetObjectDefMinDistance(silverID, 0.0);
		rmSetObjectDefMaxDistance(silverID, rmXFractionToMeters(0.5));

		rmAddObjectDefConstraint(silverID, avoidFastCoin);
		rmAddObjectDefConstraint(silverID, avoidCoin);
		rmAddObjectDefConstraint(silverID, avoidAll);
		rmAddObjectDefConstraint(silverID, avoidImpassableLand);
		rmAddObjectDefConstraint(silverID, avoidTradeRoute);
		rmAddObjectDefConstraint(silverID, avoidSocket);
		rmAddObjectDefConstraint(silverID, avoidStartingUnits);
		
		// KEEP SILVER AWAY FROM THE WATER, TO AVOID THE ART PROBLEM WITH THE "CLIFFS."
		rmAddObjectDefConstraint(silverID, avoidWater30);
		
		rmPlaceObjectDefAtLoc(silverID, 0, 0.5, 0.5);
   }
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.80);
/*================================================================================================================*/   
// *************************************** DEFINE AND PLACE THE FORESTS: **************************************** //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/
      int forestTreeID = 0;
      numTries = 6*cNumberNonGaiaPlayers;
      failCount = 0;

      for (i = 0; <numTries)
   {   
      int forest = rmCreateArea("forest "+i, rmAreaID("big continent"));
      rmSetAreaWarnFailure(forest, false);
      rmSetAreaSize(forest, rmAreaTilesToFraction(200), rmAreaTilesToFraction(250));
      rmSetAreaForestType(forest, "rockies snow forest");
      rmSetAreaForestDensity(forest, 1.0);
      rmSetAreaForestClumpiness(forest, 0.9);
      rmSetAreaForestUnderbrush(forest, 0.0);
      rmSetAreaCoherence(forest, 0.4);
      rmSetAreaSmoothDistance(forest, 10);
      rmAddAreaToClass(forest, rmClassID("classForest")); 
      rmAddAreaConstraint(forest, forestConstraint);
      rmAddAreaConstraint(forest, avoidAll);
      rmAddAreaConstraint(forest, avoidImpassableLand); 
      rmAddAreaConstraint(forest, avoidTradeRoute);
	  rmAddAreaConstraint(forest, avoidStartingUnits);
		rmAddAreaConstraint(forest, avoidSocket);
      if(rmBuildArea(forest) == false)
      {
         // Stop trying once we fail 3 times in a row.
         failCount++;
         if(failCount == 5)
            break;
      }
      else
         failCount = 0; 
   } 
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.85);
/*================================================================================================================*/   
// *************************************** DEFINE AND PLACE THE DEERS: ****************************************** //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/
      int deerID = rmCreateObjectDef("deer herd");
	  int bonusChance = rmRandFloat(0, 1);
/*----------------------------------------------------------------------------------------------------------------*/   
	  if(bonusChance<0.5)
      rmAddObjectDefItem(deerID, "deer", rmRandInt(6,8), 4.0);
      else
      rmAddObjectDefItem(deerID, "deer", rmRandInt(7,9), 6.0);
/*----------------------------------------------------------------------------------------------------------------*/
      rmSetObjectDefMinDistance(deerID, 0.0);
      rmSetObjectDefMaxDistance(deerID, rmXFractionToMeters(0.5));
      rmAddObjectDefConstraint(deerID, avoidDeer);
	  rmAddObjectDefConstraint(deerID, avoidCaribou);
	  rmAddObjectDefConstraint(deerID, avoidAll);
	  rmAddObjectDefConstraint(deerID, avoidCliffs);
	  rmAddObjectDefConstraint(deerID, avoidSocket);
	  rmAddObjectDefConstraint(deerID, avoidTradeRoute);
      rmAddObjectDefConstraint(deerID, avoidImpassableLand);
      rmAddObjectDefConstraint(deerID, avoidStartingUnits);
	  rmSetObjectDefCreateHerd(deerID, true);
	  rmPlaceObjectDefInArea(deerID, 0, bigContinentID, cNumberNonGaiaPlayers*5);
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.90);
/*================================================================================================================*/   
// *************************************** DEFINE AND PLACE THE SHEEPS: ***************************************** //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/
      int sheepID = rmCreateObjectDef("sheep");
	  rmAddObjectDefItem(sheepID, "sheep", 2, 4.0);
	  rmSetObjectDefMinDistance(sheepID, 0.0);
	  rmSetObjectDefMaxDistance(sheepID, rmXFractionToMeters(0.5));
	  rmAddObjectDefConstraint(sheepID, avoidSheep);
	  rmAddObjectDefConstraint(sheepID, avoidAll);
	  rmAddObjectDefConstraint(sheepID, avoidSocket);
	  rmAddObjectDefConstraint(sheepID, avoidTradeRoute);
	  rmAddObjectDefConstraint(sheepID, longPlayerConstraint);
	  rmAddObjectDefConstraint(sheepID, avoidCliffs);
	  rmAddObjectDefConstraint(sheepID, avoidImpassableLand);
	  rmPlaceObjectDefAtLoc(sheepID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*2);
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.95);
/*================================================================================================================*/   
// *************************** ROCK WALLS CAN GET PLACED LAST:  MAY NOT PLACE AT ALL: *************************** //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/
        int stoneWallType = -1;
	    int stoneWallID = -1;
	    int stoneWallCount = cNumberNonGaiaPlayers*2;	
	    rmEchoInfo("stoneWall count = "+stoneWallCount);

	    for(i = 0; < stoneWallCount)
	{
		stoneWallType = rmRandInt(1,4);
        stoneWallID = rmCreateGrouping("stone wall "+i, "ne_rockwall "+stoneWallType);
		rmAddGroupingToClass(stoneWallID, rmClassID("classWall"));
        rmSetGroupingMinDistance(stoneWallID, 0.0);
        rmSetGroupingMaxDistance(stoneWallID, rmXFractionToMeters(0.5));
		rmAddGroupingConstraint(stoneWallID, avoidFastCoin);
		rmAddGroupingConstraint(stoneWallID, avoidImpassableLand);
		rmAddGroupingConstraint(stoneWallID, avoidTradeRoute);
		rmAddGroupingConstraint(stoneWallID, avoidSocket);
		rmAddGroupingConstraint(stoneWallID, wallConstraint);
		rmAddGroupingConstraint(stoneWallID, avoidWater20);
		rmAddGroupingConstraint(stoneWallID, avoidStartingUnits);
		rmPlaceGroupingAtLoc(stoneWallID, 0, 0.5, 0.5);
   }
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",1.00);
/*================================================================================================================*/   
}  
/*----------------------------------------------------------------------------------------------------------------*/
// ************************************ THIS IS THE END OF THE MAP: ********************************************* //
/*----------------------------------------------------------------------------------------------------------------*/		
    