// ALASKA

include "mercenaries.xs";
// Main entry point for random map script
void main(void)
{
   // Text
   // These status text lines are used to manually animate the map generation progress bar
   rmSetStatusText("",0.01);

   //Chooses which natives appear on the map
   int subCiv0=-1;
   int subCiv1=-1;
   int subCiv2=-1;
   int subCiv3=-1;

	// Thingy to randomize location of the four "equal" VP sites.
	int vpLocation=-1;
	// vpLocation = rmRandInt(1,4);
	vpLocation = 1;

	int whichVariation=-1;
	// Used to be 1-4, but taking the mega-cliffs out for now.
	whichVariation = rmRandInt(1,2);

	int whichNative=rmRandInt(1,4);
	if ( whichNative > 1 )
	{
		subCiv0=rmGetCivID("Cree");
		rmEchoInfo("subCiv0 is Cree "+subCiv0);

		subCiv1=rmGetCivID("Cree");
		rmEchoInfo("subCiv1 is Cree "+subCiv1);
	}
	else
	{
		subCiv0=rmGetCivID("Nootka");
		rmEchoInfo("subCiv0 is Nootka "+subCiv0);

		subCiv1=rmGetCivID("Nootka");
		rmEchoInfo("subCiv1 is Nootka "+subCiv1);
	}

	subCiv2=rmGetCivID("Lakota");
	rmEchoInfo("subCiv2 is Lakota "+subCiv2);

	rmSetSubCiv(0, "Nootka", true);
	rmSetSubCiv(1, "Cree", true);
	rmSetSubCiv(2, "Lakota", true);

	float handedness = rmRandFloat(0, 1);

   // Picks the map size
	int playerTiles=12500;
   if (cNumberNonGaiaPlayers >4)
		playerTiles = 11500;

   // Picks default terrain and water
   rmSetSeaType("great lakes ice");
   int size=2.0*sqrt(cNumberNonGaiaPlayers*playerTiles);
   rmEchoInfo("Map size="+size+"m x "+size+"m");
   rmSetMapSize(size, size);

	// Some map turbulence...
	rmSetMapElevationParameters(cElevTurbulence, 0.4, 6, 0.7, 5.0);  // Like Texas for the moment.
	rmSetMapElevationHeightBlend(0.2);

   // Picks a default water height
   rmSetSeaLevel(4.0);
   rmEnableLocalWater(false);
   rmTerrainInitialize("water");
	rmSetMapType("yukon");
	rmSetMapType("water");
	rmSetWorldCircleConstraint(true);
	rmSetWindMagnitude(2.0);
	// rmSetLightingSet("yukon");
	rmSetLightingSet("default");
	rmSetMapType("snow");

	// Sets up the lighting change trigger - happy dawn in New England

	rmCreateTrigger("Day");
   rmSwitchToTrigger(rmTriggerID("Day"));
   rmSetTriggerActive(true);
   rmAddTriggerCondition("Timer");
   rmSetTriggerConditionParamInt("Param1", 2);
   rmAddTriggerEffect("Set Lighting");
   rmSetTriggerEffectParam("SetName", "yukon");
   rmSetTriggerEffectParamInt("FadeTime", 120);

	// Choose mercs.
	chooseMercs();

	// Make it snow
   rmSetGlobalSnow( 0.7 );

   // Define some classes. These are used later for constraints.
   int classPlayer=rmDefineClass("player");
   rmDefineClass("classHill");
   rmDefineClass("classCliff");
   rmDefineClass("classPatch");
	rmDefineClass("classWall");
   int classbigContinent=rmDefineClass("big continent");
   rmDefineClass("corner");
   rmDefineClass("starting settlement");
   rmDefineClass("startingUnit");
   rmDefineClass("classForest");
   rmDefineClass("importantItem");
	rmDefineClass("secrets");
	rmDefineClass("socketClass");
	rmDefineClass("nuggets");

   // -------------Define constraints
   // These are used to have objects and areas avoid each other
   
   // Map edge constraints
   int playerEdgeConstraint=rmCreateBoxConstraint("player edge of map", rmXTilesToFraction(6), rmZTilesToFraction(6), 1.0-rmXTilesToFraction(6), 1.0-rmZTilesToFraction(6), 0.01);
   int longPlayerConstraint=rmCreateClassDistanceConstraint("continent stays away from players", classPlayer, 12.0);

   // Player constraints
   int playerConstraint=rmCreateClassDistanceConstraint("player vs. player", classPlayer, 10.0);
   int smallMapPlayerConstraint=rmCreateClassDistanceConstraint("stay away from players a lot", classPlayer, 70.0);

   // Directional constraints
	int Northwestward=rmCreatePieConstraint("northwestMapConstraint", 0.6, 0.6, 0, rmZFractionToMeters(0.9), rmDegreesToRadians(285), rmDegreesToRadians(75));  // 225 135, 300, 45
   int Southeastward=rmCreatePieConstraint("southeastMapConstraint", 0.5, 0.5, 0, rmZFractionToMeters(0.5), rmDegreesToRadians(90), rmDegreesToRadians(270));

   // Bonus area constraint.
   int bigContinentConstraint=rmCreateClassDistanceConstraint("avoid bonus island", classbigContinent, 25.0);

   // Resource avoidance
   int forestConstraint=rmCreateClassDistanceConstraint("forest vs. forest", rmClassID("classForest"), 10.0);
   int avoidDeer=rmCreateTypeDistanceConstraint("food avoids food", "deer", 45.0);
	int avoidFastCoin=rmCreateTypeDistanceConstraint("fast coin avoids coin", "gold", 30.0);
   int avoidCoin=rmCreateTypeDistanceConstraint("coin avoids coin", "gold", 35);
   int avoidNugget=rmCreateTypeDistanceConstraint("nugget avoid nugget", "AbstractNugget", 35.0);
   int avoidPlayerNugget=rmCreateTypeDistanceConstraint("player nugget avoid nugget", "AbstractNugget", 20.0);
   int avoidNuggetSmall=rmCreateTypeDistanceConstraint("nugget avoid nugget small", "AbstractNugget", 10.0);

   // Avoid impassable land
	int avoidImpassableLand=rmCreateTerrainDistanceConstraint("avoid impassable land", "Land", false, 6.0);
	int shortAvoidImpassableLand=rmCreateTerrainDistanceConstraint("short avoid impassable land", "Land", false, 2.0);
	int avoidCliffs=rmCreateClassDistanceConstraint("cliff vs. cliff", rmClassID("classCliff"), 30.0);
   int hillConstraint=rmCreateClassDistanceConstraint("hill vs. hill", rmClassID("classHill"), 10.0);
   int shortHillConstraint=rmCreateClassDistanceConstraint("patches vs. hill", rmClassID("classHill"), 5.0);
	int patchConstraint=rmCreateClassDistanceConstraint("patch vs. patch", rmClassID("classPatch"), 5.0);
	int wallConstraint=rmCreateClassDistanceConstraint("wall vs. wall", rmClassID("classWall"), 40.0);
	int avoidSheep=rmCreateTypeDistanceConstraint("sheep avoids sheep", "sheep", 40.0);

   // Specify true so constraint stays outside of circle (i.e. inside corners)
   int cornerConstraint0=rmCreateCornerConstraint("in corner 0", 0, true);
   int cornerConstraint1=rmCreateCornerConstraint("in corner 1", 1, true);
   int cornerConstraint2=rmCreateCornerConstraint("in corner 2", 2, true);
   int cornerConstraint3=rmCreateCornerConstraint("in corner 3", 3, true);

   // Unit avoidance
   int avoidStartingUnits=rmCreateClassDistanceConstraint("objects avoid starting units", rmClassID("startingUnit"), 20.0);
   int avoidStartingUnitsSmall=rmCreateClassDistanceConstraint("objects avoid starting units small", rmClassID("startingUnit"), 5.0);

   // ships vs. ships
   int shipVsShip=rmCreateTypeDistanceConstraint("ships avoid ship", "ship", 5.0);

   // Decoration avoidance
   int avoidAll=rmCreateTypeDistanceConstraint("avoid all", "all", 6.0);

   // VP avoidance
   int avoidTradeRoute = rmCreateTradeRouteDistanceConstraint("trade route", 10.0);
   int avoidImportantItem=rmCreateClassDistanceConstraint("secrets etc avoid each other", rmClassID("importantItem"), 30.0);
	int avoidSocket=rmCreateClassDistanceConstraint("avoid sockets", rmClassID("socketClass"), 12.0);

   // Constraint to avoid water.
   int avoidWater4 = rmCreateTerrainDistanceConstraint("avoid water", "Land", false, 4.0);
   int avoidWater15 = rmCreateTerrainDistanceConstraint("avoid water 15", "Land", false, 15.0);
   int avoidWater20 = rmCreateTerrainDistanceConstraint("avoid water medium", "Land", false, 20.0);
   int avoidWater30 = rmCreateTerrainDistanceConstraint("avoid water mid-long", "Land", false, 30.0);
   int avoidWater40 = rmCreateTerrainDistanceConstraint("avoid water long", "Land", false, 40.0);

   // New extra stuff for water spawn point avoidance.
	int flagLand = rmCreateTerrainDistanceConstraint("flag vs land", "land", true, 20.0);
	int flagVsFlag = rmCreateTypeDistanceConstraint("flag avoid same", "HomeCityWaterSpawnFlag", 15);
	int flagEdgeConstraint = rmCreatePieConstraint("flags stay near edge of map", 0.5, 0.5, rmGetMapXSize()-20, rmGetMapXSize()-10, 0, 0, 0);

	int circleConstraint=rmCreatePieConstraint("circle Constraint", 0.5, 0.5, 0, rmZFractionToMeters(0.47), rmDegreesToRadians(0), rmDegreesToRadians(360));

	int whaleLand = rmCreateTerrainDistanceConstraint("whale v. land", "land", true, 20.0);

   // Text
   rmSetStatusText("",0.10);

	// DEFINE AREAS
   // Set up player starting locations. These are just used to place Caravels away from each other.
   /* DAL - old placement.
	rmSetPlacementSection(0.65, 0.35);
   rmSetTeamSpacingModifier(0.50);
   rmPlacePlayersCircular(0.45, 0.45, rmDegreesToRadians(5.0));
	*/

   // Text
   rmSetStatusText("",0.20);

	// Build up big continent
   int bigContinentID=rmCreateArea("big continent");
   rmSetAreaSize(bigContinentID, 0.52, 0.52);		// 0.65, 0.65
   rmSetAreaWarnFailure(bigContinentID, false);
   rmAddAreaConstraint(bigContinentID, longPlayerConstraint);
   rmAddAreaToClass(bigContinentID, classbigContinent);
   rmSetAreaSmoothDistance(bigContinentID, 25);
	rmSetAreaMix(bigContinentID, "rockies_snow");
   rmSetAreaElevationType(bigContinentID, cElevTurbulence);
   rmSetAreaElevationVariation(bigContinentID, 6.5);
   rmSetAreaBaseHeight(bigContinentID, 10.0);
   rmSetAreaElevationMinFrequency(bigContinentID, 0.09);
   rmSetAreaElevationOctaves(bigContinentID, 3);
   rmSetAreaElevationPersistence(bigContinentID, 0.2);      
	rmSetAreaCoherence(bigContinentID, 0.5);
	rmSetAreaLocation(bigContinentID, 0.85, 0.5);
   rmSetAreaEdgeFilling(bigContinentID, 5);
	rmSetAreaObeyWorldCircleConstraint(bigContinentID, false);
	rmBuildArea(bigContinentID);

	rmSetStatusText("",0.30);

   rmSetStatusText("",0.35);

	if ( cNumberTeams == 2 )
	{
		rmSetPlacementTeam(0);
		rmPlacePlayersLine(0.55, 0.2, 0.8, 0.2, 0.2, 0.0);

		rmSetPlacementTeam(1);
		rmPlacePlayersLine(0.6, 0.8, 0.8, 0.8, 0.2, 0.0);
	}
	else
	{
	   rmSetPlacementSection(0.25, 0.75);
	   rmSetTeamSpacingModifier(0.75);
	   rmPlacePlayersCircular(0.4, 0.4, 0);
	}

    // Set up player areas.
   float playerFraction=rmAreaTilesToFraction(100);
   for(i=1; <cNumberPlayers)
   {
      // Create the area.
      int id=rmCreateArea("Player"+i);
      // Assign to the player.
      rmSetPlayerArea(i, id);
      // Set the size.
      rmSetAreaSize(id, playerFraction, playerFraction);
      rmAddAreaToClass(id, classPlayer);
      rmSetAreaMinBlobs(id, 1);
      rmSetAreaMaxBlobs(id, 1);
      // rmAddAreaConstraint(id, playerConstraint); 
      // rmAddAreaConstraint(id, playerEdgeConstraint); 
      rmSetAreaLocPlayer(id, i);
      rmSetAreaWarnFailure(id, false);
   }

   // Build the areas.
   rmBuildAllAreas();

   // Placement order
   // Trade route -> Lakes -> Natives -> Secrets -> Cliffs -> Nuggets
   // Text
   rmSetStatusText("",0.40);

   // TRADE ROUTES
	int tradeRouteID = rmCreateTradeRoute();

	int socketID=rmCreateObjectDef("sockets to dock Trade Posts");
	rmAddObjectDefItem(socketID, "SocketTradeRoute", 1, 0.0);
	rmSetObjectDefAllowOverlap(socketID, true);
	rmAddObjectDefToClass(socketID, rmClassID("socketClass"));
	rmSetObjectDefMinDistance(socketID, 0.0);
	rmSetObjectDefMaxDistance(socketID, 8.0);
	if ( cNumberNonGaiaPlayers < 4 )
	{
		rmAddObjectDefConstraint(socketID, avoidWater15);					// To make it avoid the water and the cliffs.
	}

	else 
	{
		rmAddObjectDefConstraint(socketID, avoidWater20);					// To make it avoid the water and the cliffs - by more if larger map
	}

	// Hacky trade route stuff for weird FFA cases, to handle player placement.
	if ( cNumberTeams == 3 || cNumberTeams > 4 )
	{
		rmAddTradeRouteWaypoint(tradeRouteID, 0.9, 0.1);
	}
	else
	{
		rmAddTradeRouteWaypoint(tradeRouteID, 0.75, 0.1);
	}
	rmAddTradeRouteWaypoint(tradeRouteID, 0.55, 0.5);

	if ( cNumberNonGaiaPlayers < 4 )
	{
		rmAddRandomTradeRouteWaypoints(tradeRouteID, 0.9, 0.9, 10, 2);
	}
	else
	{
		rmAddRandomTradeRouteWaypoints(tradeRouteID, 0.75, 0.9, 10, 4);
	}
   
   bool placedTradeRoute = rmBuildTradeRoute(tradeRouteID, "dirt");
   if(placedTradeRoute == false)
      rmEchoError("Failed to place trade route"); 

	// add the meeting poles along the trade route.
   rmSetObjectDefTradeRouteID(socketID, tradeRouteID);
   vector socketLoc = rmGetTradeRouteWayPoint(tradeRouteID, 0.1);
   rmPlaceObjectDefAtPoint(socketID, 0, socketLoc);

   socketLoc = rmGetTradeRouteWayPoint(tradeRouteID, 0.5);
	rmPlaceObjectDefAtPoint(socketID, 0, socketLoc);

   socketLoc = rmGetTradeRouteWayPoint(tradeRouteID, 0.85);
	rmPlaceObjectDefAtPoint(socketID, 0, socketLoc);

		// Place two crazy cliffs at the spots the lakes WOULD have been otherwise (i.e., if the lakes aren't there).
	if ( whichVariation > 0 )
	{
		int bigCliff1ID=rmCreateArea("big cliff 1");
	   rmSetAreaSize(bigCliff1ID, rmAreaTilesToFraction(1200), rmAreaTilesToFraction(1200));
		rmSetAreaWarnFailure(bigCliff1ID, false);
		rmSetAreaCliffType(bigCliff1ID, "rocky mountain2");
		rmAddAreaToClass(bigCliff1ID, rmClassID("classCliff"));		// Attempt to keep cliffs away from each other.

		rmSetAreaCliffEdge(bigCliff1ID, 1, 0.6, 0.1, 1.0, 0);  // DAL NOTE: Number of edges, second is size of each edge, third is variance
		rmSetAreaCliffPainting(bigCliff1ID, true, true, true, 1.5, true);
		rmSetAreaCliffHeight(bigCliff1ID, 6, 1.0, 1.0);
		rmSetAreaHeightBlend(bigCliff1ID, 1.0);
		rmAddAreaTerrainLayer(bigCliff1ID, "rockies\groundsnow8_roc", 0, 2);

		rmAddAreaConstraint(bigCliff1ID, avoidImportantItem);
		rmAddAreaConstraint(bigCliff1ID, avoidTradeRoute);
		rmSetAreaMinBlobs(bigCliff1ID, 3);
		rmSetAreaMaxBlobs(bigCliff1ID, 5);
		rmSetAreaMinBlobDistance(bigCliff1ID, 15.0);
		rmSetAreaMaxBlobDistance(bigCliff1ID, 25.0);
		rmSetAreaSmoothDistance(bigCliff1ID, 15);
		rmSetAreaCoherence(bigCliff1ID, 0.4);
		
		rmSetAreaLocation(bigCliff1ID, 0.40, 0.5);
		rmAddAreaInfluenceSegment(bigCliff1ID, 0.4, 0.52, 0.35, 0.68);
		rmBuildArea(bigCliff1ID);

		int bigCliff2ID=rmCreateArea("big cliff 2");
	   rmSetAreaSize(bigCliff2ID, rmAreaTilesToFraction(1200), rmAreaTilesToFraction(1200));
		rmSetAreaWarnFailure(bigCliff2ID, false);
		rmSetAreaCliffType(bigCliff2ID, "rocky mountain2");
		rmAddAreaToClass(bigCliff2ID, rmClassID("classCliff"));		// Attempt to keep cliffs away from each other.

		rmSetAreaCliffEdge(bigCliff2ID, 1, 0.6, 0.1, 1.0, 0);
		rmSetAreaCliffPainting(bigCliff2ID, true, true, true, 1.5, true);
		rmSetAreaCliffHeight(bigCliff2ID, 6, 1.0, 1.0);
		rmSetAreaHeightBlend(bigCliff2ID, 1.0);
		rmAddAreaTerrainLayer(bigCliff2ID, "rockies\groundsnow8_roc", 0, 2);

		rmAddAreaConstraint(bigCliff2ID, avoidImportantItem);
		rmAddAreaConstraint(bigCliff2ID, avoidTradeRoute);
		rmSetAreaMinBlobs(bigCliff2ID, 3);
		rmSetAreaMaxBlobs(bigCliff2ID, 5);
		rmSetAreaMinBlobDistance(bigCliff2ID, 15.0);
		rmSetAreaMaxBlobDistance(bigCliff2ID, 25.0);
		rmSetAreaSmoothDistance(bigCliff2ID, 15);
		rmSetAreaCoherence(bigCliff2ID, 0.4);

		rmSetAreaLocation(bigCliff2ID, 0.9, 0.4);
		rmAddAreaInfluenceSegment(bigCliff2ID, 0.6, 0.52, 0.65, 0.68);
		rmBuildArea(bigCliff2ID);
	}

   // Isles of Shoals - these are set in specific locations.
   int bonusIslandID1=rmCreateArea("isle of shoals 1");
   rmSetAreaSize(bonusIslandID1, rmAreaTilesToFraction(450), rmAreaTilesToFraction(450));
   rmSetAreaTerrainType(bonusIslandID1, "yukon\ground6_yuk");
   rmSetAreaMix(bonusIslandID1, "rockies_snow");
	// rmSetAreaMix(bonusIslandID1, "newengland_rock");
   rmSetAreaBaseHeight(bonusIslandID1, 6.0);
   rmSetAreaSmoothDistance(bonusIslandID1, 5);
   rmSetAreaWarnFailure(bonusIslandID1, false);
	rmSetAreaMinBlobs(bonusIslandID1, 4);
   rmSetAreaMaxBlobs(bonusIslandID1, 5);
   rmSetAreaMinBlobDistance(bonusIslandID1, 8.0);
	rmSetAreaMaxBlobDistance(bonusIslandID1, 12.0);
   rmSetAreaCoherence(bonusIslandID1, 0.50);
   rmAddAreaConstraint(bonusIslandID1, bigContinentConstraint);
   rmAddAreaConstraint(bonusIslandID1, longPlayerConstraint);

	// this may be the only island!  On a 2 or a 4.
	if ( whichVariation == 1 || whichVariation == 3 )
	{
		rmSetAreaLocation(bonusIslandID1, 0.15, 0.40);
	}
	else
		rmSetAreaLocation(bonusIslandID1, 0.15, 0.50);
   rmBuildArea(bonusIslandID1);

	// Only make the second island half the time.
	if ( whichVariation == 1 || whichVariation == 3 )
	{
		int bonusIslandID2=rmCreateArea("isle of shoals 2");
		rmSetAreaSize(bonusIslandID2, rmAreaTilesToFraction(450), rmAreaTilesToFraction(450));
		rmSetAreaTerrainType(bonusIslandID2, "yukon\ground6_yuk");
		rmSetAreaMix(bonusIslandID2, "rockies_snow");
		// rmSetAreaMix(bonusIslandID2, "newengland_rock");
		rmSetAreaBaseHeight(bonusIslandID2, 6.0);
		rmSetAreaSmoothDistance(bonusIslandID2, 5);
		rmSetAreaWarnFailure(bonusIslandID2, false);
		rmSetAreaMinBlobs(bonusIslandID2, 4);
		rmSetAreaMaxBlobs(bonusIslandID2, 5);
		rmSetAreaMinBlobDistance(bonusIslandID2, 8.0);
		rmSetAreaMaxBlobDistance(bonusIslandID2, 12.0);
		rmSetAreaCoherence(bonusIslandID2, 0.50);
		rmAddAreaConstraint(bonusIslandID2, bigContinentConstraint);
		rmAddAreaConstraint(bonusIslandID2, longPlayerConstraint);
		rmSetAreaLocation(bonusIslandID2, 0.60, 0.15);
		rmBuildArea(bonusIslandID2);
	}

   // NATIVE AMERICANS
   // Text
   rmSetStatusText("",0.50);

   float NativeVillageLoc = rmRandFloat(0,1);
     
   // Iroquois are always on the mainland
   int nootkaVillageAID = -1;
   int nootkaVillageType = rmRandInt(1,3);
   if ( whichNative > 1 )
   {
		nootkaVillageAID = rmCreateGrouping("Nootka village A", "native nootka village "+nootkaVillageType);
   }
   else
   {
	   	nootkaVillageAID = rmCreateGrouping("Nootka village A", "native nootka village "+nootkaVillageType);
   }
   rmSetGroupingMinDistance(nootkaVillageAID, 0.0);
   rmSetGroupingMaxDistance(nootkaVillageAID, rmXFractionToMeters(0.05));
   rmAddGroupingConstraint(nootkaVillageAID, avoidImpassableLand);
   rmAddGroupingToClass(nootkaVillageAID, rmClassID("importantItem"));
   rmAddGroupingConstraint(nootkaVillageAID, avoidTradeRoute);

	if ( vpLocation < 3 )
	{
		rmPlaceGroupingAtLoc(nootkaVillageAID, 0, 0.7, 0.5); // used to be 0.3 DAL
	}
	else if ( vpLocation == 3 )
	{
		rmPlaceGroupingAtLoc(nootkaVillageAID, 0, 0.2, 0.5);
	}
	else
	{
		rmPlaceGroupingAtLoc(nootkaVillageAID, 0, 0.2, 0.5);
	}
	
	int nootkaVillageBID = -1;
	nootkaVillageType = rmRandInt(1,3);
	if ( whichNative > 1 )
	{
		nootkaVillageBID = rmCreateGrouping("Nootka village A", "native nootka village "+nootkaVillageType);
	}
	else
	{
		nootkaVillageBID = rmCreateGrouping("Nootka village A", "native nootka village "+nootkaVillageType);
	}
	rmSetGroupingMinDistance(nootkaVillageBID, 0.0);
	rmSetGroupingMaxDistance(nootkaVillageBID, rmXFractionToMeters(0.05));
	rmAddGroupingConstraint(nootkaVillageBID, avoidImpassableLand);
	rmAddGroupingToClass(nootkaVillageBID, rmClassID("importantItem"));
	rmAddGroupingConstraint(nootkaVillageBID, avoidTradeRoute);
	
	if ( vpLocation == 1 )
	{
		rmPlaceGroupingAtLoc(nootkaVillageBID, 0, 0.7, 0.5); // used to be 0.7 DAL
	}
	else if ( vpLocation == 2 )
	{
		rmPlaceGroupingAtLoc(nootkaVillageBID, 0, 0.2, 0.5); 
	}
	else if ( vpLocation == 3 )
	{
		rmPlaceGroupingAtLoc(nootkaVillageBID, 0, 0.9, 0.7); 
	}
	else
	{
		rmPlaceGroupingAtLoc(nootkaVillageBID, 0, 0.9, 0.3);
	}

	// The Cree get placed on one of the islands.  Ahistorical, perhaps, but fun!
   int lakotaVillageID = -1;
   int lakotaVillageType = rmRandInt(1,3);
   lakotaVillageID = rmCreateGrouping("lakota village A", "native lakota village "+lakotaVillageType);
   rmSetGroupingMinDistance(lakotaVillageID, 0.0);
   rmSetGroupingMaxDistance(lakotaVillageID, rmXFractionToMeters(0.05));
   rmAddGroupingConstraint(lakotaVillageID, avoidImpassableLand);
   rmAddGroupingToClass(lakotaVillageID, rmClassID("importantItem"));
	if ( vpLocation < 3 )
	{
		// Only gets placed if island #2 actually exists.
		if ( whichVariation > 0 )
		{
			rmPlaceGroupingInArea(lakotaVillageID, 0, bonusIslandID1);
		}
	}
	else
	{
		rmPlaceGroupingInArea(lakotaVillageID, 0, bonusIslandID1);
	}

   // Starting Unit placement
	int startingUnits = rmCreateStartingUnitsObjectDef(5.0);
	rmSetObjectDefMinDistance(startingUnits, 5.0);
	rmSetObjectDefMaxDistance(startingUnits, 10.0);
	rmAddObjectDefToClass(startingUnits, rmClassID("startingUnit"));
	rmAddObjectDefConstraint(startingUnits, avoidAll);

	int startingTCID= rmCreateObjectDef("startingTC");
	if ( rmGetNomadStart())
	{
		rmAddObjectDefItem(startingTCID, "CoveredWagon", 1, 0.0);
	}
	else
	{
		rmAddObjectDefItem(startingTCID, "TownCenter", 1, 0.0);
	}
	rmAddObjectDefToClass(startingTCID, rmClassID("startingUnit"));

	int silverType = -1;
	int playerGoldID = -1;

	int StartAreaTreeID=rmCreateObjectDef("starting trees");
	rmAddObjectDefItem(StartAreaTreeID, "TreeRockiesSnow", 1, 0.0);
	rmSetObjectDefMinDistance(StartAreaTreeID, 10.0);
	rmSetObjectDefMaxDistance(StartAreaTreeID, 15.0);
	rmAddObjectDefConstraint(StartAreaTreeID, avoidStartingUnitsSmall);

	int StartBerryBushID=rmCreateObjectDef("starting BerryBush");
	rmAddObjectDefItem(StartBerryBushID, "BerryBush", 3, 5.0);
	rmSetObjectDefMinDistance(StartBerryBushID, 10.0);
	rmSetObjectDefMaxDistance(StartBerryBushID, 15.0);
	rmAddObjectDefConstraint(StartBerryBushID, avoidStartingUnitsSmall);

	int playerNuggetID=rmCreateObjectDef("player nugget");
	rmAddObjectDefItem(playerNuggetID, "nugget", 1, 0.0);
	rmAddObjectDefToClass(playerNuggetID, rmClassID("nuggets"));
    rmSetObjectDefMinDistance(playerNuggetID, 30.0);
    rmSetObjectDefMaxDistance(playerNuggetID, 35.0);
	rmAddObjectDefConstraint(playerNuggetID, avoidStartingUnitsSmall);
	rmAddObjectDefConstraint(playerNuggetID, avoidPlayerNugget);
	rmAddObjectDefConstraint(playerNuggetID, circleConstraint);
	// rmAddObjectDefConstraint(playerNuggetID, avoidImportantItem);

	int waterFlagID=-1;
	
	for(i=1; <cNumberPlayers)
	{
		rmClearClosestPointConstraints();
		// Place starting units and a TC!
		rmPlaceObjectDefAtLoc(startingTCID, i, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(startingUnits, i, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));

		// Everyone gets one ore grouping close by.
		silverType = rmRandInt(1,10);
		playerGoldID = rmCreateObjectDef("player silver closer "+i);
		rmAddObjectDefItem(playerGoldID, "mine", 1, 0.0);
		// rmAddGroupingToClass(playerGoldID, rmClassID("importantItem"));
		rmAddObjectDefConstraint(playerGoldID, avoidTradeRoute);
		rmAddObjectDefConstraint(playerGoldID, avoidStartingUnitsSmall);
		rmSetObjectDefMinDistance(playerGoldID, 15.0);
		rmSetObjectDefMaxDistance(playerGoldID, 20.0);
		rmPlaceObjectDefAtLoc(playerGoldID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));

		// Placing starting Pronghorns...
		/*
		rmPlaceObjectDefAtLoc(StartDeerID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(StartDeerID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(StartDeerID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(StartDeerID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		*/
		rmPlaceObjectDefAtLoc(StartBerryBushID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		
		// Placing starting trees...
		rmPlaceObjectDefAtLoc(StartAreaTreeID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(StartAreaTreeID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(StartAreaTreeID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(StartAreaTreeID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(StartAreaTreeID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));

		// Nuggets
		rmSetNuggetDifficulty(1, 1);
		rmPlaceObjectDefAtLoc(playerNuggetID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(playerNuggetID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));

		// Water flag
		waterFlagID=rmCreateObjectDef("HC water flag "+i);
		rmAddObjectDefItem(waterFlagID, "HomeCityWaterSpawnFlag", 1, 0.0);
		rmAddClosestPointConstraint(flagEdgeConstraint);
		rmAddClosestPointConstraint(flagVsFlag);
		rmAddClosestPointConstraint(flagLand);
		vector TCLocation = rmGetUnitPosition(rmGetUnitPlacedOfPlayer(startingTCID, i));
        vector closestPoint = rmFindClosestPointVector(TCLocation, rmXFractionToMeters(1.0));

		rmPlaceObjectDefAtLoc(waterFlagID, i, rmXMetersToFraction(xsVectorGetX(closestPoint)), rmZMetersToFraction(xsVectorGetZ(closestPoint)));
		rmClearClosestPointConstraints();
	}

	// Text
   rmSetStatusText("",0.60);

   // Define and place Nuggets
	int nuggetID= rmCreateObjectDef("nugget"); 
	rmAddObjectDefItem(nuggetID, "Nugget", 1, 0.0);
	rmSetObjectDefMinDistance(nuggetID, 0.0);
	rmSetObjectDefMaxDistance(nuggetID, rmXFractionToMeters(0.5));
	rmAddObjectDefConstraint(nuggetID, shortAvoidImpassableLand);
  	rmAddObjectDefConstraint(nuggetID, avoidNugget);
	rmAddObjectDefConstraint(nuggetID, avoidStartingUnits);
  	rmAddObjectDefConstraint(nuggetID, avoidTradeRoute);
	rmAddObjectDefConstraint(nuggetID, avoidSocket);
  	rmAddObjectDefConstraint(nuggetID, avoidAll);
  	rmAddObjectDefConstraint(nuggetID, avoidWater20);
	rmAddObjectDefConstraint(nuggetID, circleConstraint);
	rmSetNuggetDifficulty(2, 3);
	rmPlaceObjectDefInArea(nuggetID, 0, bigContinentID, cNumberNonGaiaPlayers*5);

	// Alternate nugget definition for island nuggets - no constraints (practically)
	/*
	int nuggetID2= rmCreateObjectDef("nugget 2"); 
	rmAddObjectDefItem(nuggetID2, "Nugget", 1, 0.0);
	rmSetObjectDefMinDistance(nuggetID2, 0.0);
	rmSetObjectDefMaxDistance(nuggetID2, rmXFractionToMeters(0.5));
	rmAddObjectDefConstraint(nuggetID2, shortAvoidImpassableLand);

	// Extra nuggets on the non-native island.
	if ( vpLocation < 3 )
	{
		rmPlaceObjectDefInArea(nuggetID2, 0, bonusIslandID1, 4);
	}
	else
	{
		if ( whichVariation == 1 || whichVariation == 3 )
		{
			rmPlaceObjectDefInArea(nuggetID2, 0, bonusIslandID2, 4);
		}
	}
	*/

	// Placement of crates on the bonus islands.
	// DAL - "nuggets" for now instead
	int whichCrate=-1;
	whichCrate = rmRandInt(1,3);

	int islandCrateID= rmCreateObjectDef("mineGold"+i); 
	rmSetNuggetDifficulty(4, 4);
	rmAddObjectDefConstraint(islandCrateID, avoidWater4);
	rmAddObjectDefConstraint(islandCrateID, avoidNuggetSmall);
	if ( whichCrate == 1 )
	{
		rmAddObjectDefItem(islandCrateID, "mineGold", 1, 0.0);
	}
	else if ( whichCrate == 2 )
	{
		rmAddObjectDefItem(islandCrateID, "mineGold", 1, 0.0);
	}
	else
   		rmAddObjectDefItem(islandCrateID, "mineGold", 1, 0.0);
	

	rmPlaceObjectDefInArea(islandCrateID, 0, bonusIslandID1, 1);
	if ( whichVariation == 1 )
	{
		rmPlaceObjectDefInArea(islandCrateID, 0, bonusIslandID2, 1);
	}

	// TEMP: add four natives to the islands
	// DAL - temp trees instead.
	int islandNativeID= rmCreateObjectDef("island natives"); 
	rmAddObjectDefConstraint(islandNativeID, avoidWater4);
	// rmAddObjectDefItem(islandNativeID, "NatTomahawk", 1, 0.0);
	rmAddObjectDefItem(islandNativeID, "TreeRockiesSnow", 1, 0.0);
	rmPlaceObjectDefInArea(islandNativeID, 0, bonusIslandID1, 7);
	if ( whichVariation == 1 )
	{
		rmPlaceObjectDefInArea(islandNativeID, 0, bonusIslandID2, 7);
	}

   // fish
   int fishVsFishID=rmCreateTypeDistanceConstraint("fish v fish", "fish", 20.0);
   int fishLand = rmCreateTerrainDistanceConstraint("fish land", "land", true, 6.0);
   int whaleVsWhaleID=rmCreateTypeDistanceConstraint("whale v whale", "minkeWhale", 25.0);


   /*
   int playerFishID=rmCreateObjectDef("player fish");
   rmAddObjectDefItem(playerFishID, "FishCod", 1, 10.0);
   rmSetObjectDefMinDistance(playerFishID, 0.0);
   rmSetObjectDefMaxDistance(playerFishID, 20.0);
   rmAddObjectDefConstraint(playerFishID, fishVsFishID);
   rmAddObjectDefConstraint(playerFishID, fishLand);
   */

   // rmPlaceObjectDefPerPlayer(playerFishID, false);

   int fishID=rmCreateObjectDef("fish");
   rmAddObjectDefItem(fishID, "FishCod", 3, 5.0);
   rmSetObjectDefMinDistance(fishID, 0.0);
   rmSetObjectDefMaxDistance(fishID, rmXFractionToMeters(0.5));
   rmAddObjectDefConstraint(fishID, fishVsFishID);
   rmAddObjectDefConstraint(fishID, fishLand);
   rmPlaceObjectDefAtLoc(fishID, 0.5, 0, 0.5, cNumberNonGaiaPlayers*5);

	// FAST COIN -- WHALES
	int whaleID=rmCreateObjectDef("whale");
   rmAddObjectDefItem(whaleID, "minkeWhale", 1, 4.0);
   rmSetObjectDefMinDistance(whaleID, 0.0);
   rmSetObjectDefMaxDistance(whaleID, rmXFractionToMeters(0.5));
   rmAddObjectDefConstraint(whaleID, whaleVsWhaleID);
   rmAddObjectDefConstraint(whaleID, whaleLand);
   rmPlaceObjectDefAtLoc(whaleID, 0.5, 0, 0.5, 3*cNumberNonGaiaPlayers);


    //CARAVEL
   int colonyShipID = 0;
   for(i=1; <cNumberPlayers)
   {
		colonyShipID=rmCreateObjectDef("colony ship "+i);

		rmAddObjectDefItem(colonyShipID, "Caravel", 1, 5.0);

		rmAddObjectDefConstraint(colonyShipID, shipVsShip);
		rmAddObjectDefConstraint(colonyShipID, fishLand);
		// rmAddObjectDefConstraint(colonyShipID, Southeastward);
		rmSetObjectDefMinDistance(colonyShipID, 0.0);
		rmSetObjectDefMaxDistance(colonyShipID, rmXFractionToMeters(0.3));

		// Ship placement
		if ( rmGetPlayerTeam(i) == 0 )
		{
	   		rmPlaceObjectDefAtLoc(colonyShipID, i, 0.1, 0.1, 1);
		}
		if ( rmGetPlayerTeam(i) == 1 )
		{
	   		rmPlaceObjectDefAtLoc(colonyShipID, i, 0.4, 0.9, 1);
		}
		// vector colonyShipLocation=rmGetUnitPosition(rmGetUnitPlacedOfPlayer(colonyShipID, i));
		// rmSetHomeCityWaterSpawnPoint(i, colonyShipLocation);
	}

   // Text
   rmSetStatusText("",0.65); 
 
   // Place resources that we want forests to avoid
	// Fast Coin
	int silverID = -1;
	int silverCount = cNumberNonGaiaPlayers*3;	// 3 per player, plus starting one.
	rmEchoInfo("silver count = "+silverCount);

	for(i=0; < silverCount)
	{
		silverType = rmRandInt(1,10);
		silverID = rmCreateObjectDef("silver "+i);
		rmAddObjectDefItem(silverID, "mine", 1, 0.0);
		rmSetObjectDefMinDistance(silverID, 0.0);
		rmSetObjectDefMaxDistance(silverID, rmXFractionToMeters(0.5));

		rmAddObjectDefConstraint(silverID, avoidFastCoin);
		rmAddObjectDefConstraint(silverID, avoidCoin);
		rmAddObjectDefConstraint(silverID, avoidAll);
		rmAddObjectDefConstraint(silverID, avoidImpassableLand);
		rmAddObjectDefConstraint(silverID, avoidTradeRoute);
		rmAddObjectDefConstraint(silverID, avoidSocket);
		rmAddObjectDefConstraint(silverID, avoidStartingUnits);
		// Keep silver away from the water, to avoid the art problem with the "cliffs."
		rmAddObjectDefConstraint(silverID, avoidWater30);
		rmPlaceObjectDefAtLoc(silverID, 0, 0.5, 0.5);
   }

	// FORESTS
   int forestTreeID = 0;
   int numTries=6*cNumberNonGaiaPlayers;
   int failCount=0;

   for (i=0; <numTries)
   {   
      int forest=rmCreateArea("forest "+i, rmAreaID("big continent"));
      rmSetAreaWarnFailure(forest, false);
      rmSetAreaSize(forest, rmAreaTilesToFraction(200), rmAreaTilesToFraction(250));
      rmSetAreaForestType(forest, "rockies snow forest");
      rmSetAreaForestDensity(forest, 1.0);
      rmSetAreaForestClumpiness(forest, 0.9);
      rmSetAreaForestUnderbrush(forest, 0.0);
      rmSetAreaCoherence(forest, 0.4);
      rmSetAreaSmoothDistance(forest, 10);
      rmAddAreaToClass(forest, rmClassID("classForest")); 
      rmAddAreaConstraint(forest, forestConstraint);
      rmAddAreaConstraint(forest, avoidAll);
      rmAddAreaConstraint(forest, avoidImpassableLand); 
      rmAddAreaConstraint(forest, avoidTradeRoute);
	  rmAddAreaConstraint(forest, avoidStartingUnits);
		rmAddAreaConstraint(forest, avoidSocket);
      if(rmBuildArea(forest)==false)
      {
         // Stop trying once we fail 3 times in a row.
         failCount++;
         if(failCount==5)
            break;
      }
      else
         failCount=0; 
   } 

   // Text
   rmSetStatusText("",0.70);

 	// DEER
   int deerID=rmCreateObjectDef("caribou herd");
	int bonusChance=rmRandFloat(0, 1);
   
	if(bonusChance<0.5)
      rmAddObjectDefItem(deerID, "caribou", rmRandInt(8,12), 20);
   else
      rmAddObjectDefItem(deerID, "caribou", rmRandInt(9,13), 20);

   rmSetObjectDefMinDistance(deerID, 0.0);
   rmSetObjectDefMaxDistance(deerID, rmXFractionToMeters(0.5));
   rmAddObjectDefConstraint(deerID, avoidDeer);
	rmAddObjectDefConstraint(deerID, avoidAll);
	rmAddObjectDefConstraint(deerID, avoidSocket);
	rmAddObjectDefConstraint(deerID, avoidTradeRoute);
   rmAddObjectDefConstraint(deerID, avoidImpassableLand);
      rmAddObjectDefConstraint(deerID, avoidStartingUnits);
	rmSetObjectDefCreateHerd(deerID, true);
	rmPlaceObjectDefInArea(deerID, 0, bigContinentID, cNumberNonGaiaPlayers*5);

	// Text
   rmSetStatusText("",0.80);

	int sheepID=rmCreateObjectDef("muskOx herd");
	rmAddObjectDefItem(sheepID, "muskOx", 4, 4.0);
	rmSetObjectDefMinDistance(sheepID, 0.0);
	rmSetObjectDefMaxDistance(sheepID, rmXFractionToMeters(0.5));
	rmAddObjectDefConstraint(sheepID, avoidSheep);
	rmAddObjectDefConstraint(sheepID, avoidAll);
	rmAddObjectDefConstraint(sheepID, avoidSocket);
	rmAddObjectDefConstraint(sheepID, avoidTradeRoute);
	rmAddObjectDefConstraint(sheepID, longPlayerConstraint);
	rmAddObjectDefConstraint(sheepID, avoidCliffs);
	rmAddObjectDefConstraint(sheepID, avoidImpassableLand);
	rmPlaceObjectDefAtLoc(sheepID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*2);

   // Text
   rmSetStatusText("",0.9);

	// Silly Rock Walls can get placed last.  May not place at all...
	int stoneWallType = -1;
	int stoneWallID = -1;
	int stoneWallCount = cNumberNonGaiaPlayers*2;	
	rmEchoInfo("stoneWall count = "+stoneWallCount);

	for(i=0; < stoneWallCount)
	{
		stoneWallType = rmRandInt(1,4);
      stoneWallID = rmCreateGrouping("stone wall ");
		rmAddGroupingToClass(stoneWallID, rmClassID("classWall"));
      rmSetGroupingMinDistance(stoneWallID, 0.0);
      rmSetGroupingMaxDistance(stoneWallID, rmXFractionToMeters(0.5));
		rmAddGroupingConstraint(stoneWallID, avoidFastCoin);
		rmAddGroupingConstraint(stoneWallID, avoidImpassableLand);
		rmAddGroupingConstraint(stoneWallID, avoidTradeRoute);
		rmAddGroupingConstraint(stoneWallID, avoidSocket);
		rmAddGroupingConstraint(stoneWallID, wallConstraint);
		rmAddGroupingConstraint(stoneWallID, avoidWater20);
		rmAddGroupingConstraint(stoneWallID, avoidStartingUnits);
		rmPlaceGroupingAtLoc(stoneWallID, 0, 0.5, 0.5);
   }
}